<?php
include_once "inc/user_data.php";
$app = new controller;

?>
<!doctype html>
<html lang="en">
<head>
    <title>Loan Management</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">

    <link rel="stylesheet" href="assets/vendor/jquery-datatable/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedcolumns.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedheader.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/sweetalert/sweetalert.css"/>
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
    <style>
        td.details-control {
            background: url('assets/images/details_open.png') no-repeat center center;
            cursor: pointer;
        }

        tr.shown td.details-control {
            background: url('assets/images/details_close.png') no-repeat center center;
        }
    </style>
    <!-- Print styles. -->
    <style type="text/css" media="print">

        div#DivIdToPrint {
            display: inline ;
        }

    </style>
</head>

<body class="theme-blue">

<!-- Page Loader -->
<div class="page-loader-wrapper">
    <div class="loader">
        <div class="m-t-30"><img src="logo.png" width="48" height="48" alt="Daros"></div>
        <p>Please wait...</p>
    </div>
</div>
<!-- Overlay For Sidebars -->

<div id="wrapper">

    <?php
    include_once "inc/header.php";
    ?>

    <?php
    include_once "inc/sidebar.php";
    ?>

    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a>Inter Transfer Transactions Approval</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard"><i class="fa fa-home fa-lg"></i></a></li>
                            <li class="breadcrumb-item active">Transfer Transactions</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card" id="DivIdToPrint">
                        <div class="header">
                            <button class="fa-pull-right btn btn-primary m-l-30 font-weight-bold" id="ccv"
                                    onclick='printContent("DivIdToPrint");'>Print Report
                            </button>
                            <br>
                        </div>

                        <div class="body">

                            <div class="table-responsive">
                                <table id="" class="table table-striped table-hover js-basic-example dataTable table-custom">
                                    <thead>
                                    <tr style="font-weight: bold;color: black;font-size: 15px">
                                        <th style="width: 10px">SN</th>
                                        <th style="width: 30px">Trans Date</th>
                                        <th style="max-width: 30px">Description</th>
                                        <th style="width: 30px">Debit</th>
                                        <th style="width: 30px">Credit</th>
                                        <th style="width: 30px">from</th>
                                        <th style="width: 30px">to</th>
                                        <th style="width: 30px">Approve</th>
                                        <th style="width: 30px">Decline</th>
                                    </tr>
                                    </thead>

                                    <tbody>
                                    <?php
                                    $get_total_info = $app->banks_autose();
                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        $sn++;
                                        //$add_new_student = $app->mode_banks($values->id, $values->date_cr, $values->dr, $values->cr, $cv, $values->description);
                                        ?>
                                        <tr class="dn_<?= $values->id; ?>" style="font-weight: bold;color: black;font-size: 15px">
                                            <td><?= $sn; ?></td>
                                            <td><?php echo $newDate = date("d-m-Y:h:i:s", strtotime($values->date_cr)); ?></td>
                                            <td><?= $app->stringFormat($values->description,50); ?></td>

                                            <td>₦<?= number_format($values->dr); ?></td>
                                            <td>₦<?= number_format($values->cr); ?></td>
                                            <td><?= ($values->bank_name); ?></td>
                                            <td><?= ($values->bank_name_to); ?></td>
                                            <td><a href="ajax/approve_banks_banks.php?bank_id=<?= $values->from_bank; ?>&&amount=<?= $values->dr;  ?>&&to=<?= $values->to_bank;  ?>&&decode=<?= $values->dcode;  ?>"><button class="btn btn-default font-weight-bold">Approve</button></a></td>
                                            <td><a href="ajax/del_approve_bank_banks.php?decode=<?= $values->dcode;  ?>&&bid=<?= $values->id; ?>"><button class="btn btn-danger font-weight-bold">Decline</button></a></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>

                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/bundles/datatablescripts.bundle.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.print.min.js"></script>

<script src="assets/vendor/sweetalert/sweetalert.min.js"></script> <!-- SweetAlert Plugin Js -->
<script src="assets/vendor/toastr/toastr.js"></script>
<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/js/pages/tables/jquery-datatable.js"></script>

<script>


    function printContent(el) {
        $("#ccv").hide();
        var restorepage = $('body').html();
        var printcontent = $('#' + el).clone();
        $('body').empty().html(printcontent);
        window.print();
        $('body').html(restorepage);
    }
</script>
</body>
</html>
