<?php
include_once "inc/user_data.php";
$app = new controller;
$rtype = $app->get_request('rtype');
$sdate = $app->get_request('sdate');
$edate = $app->get_request('edate');

$s = date("Y-m-d H:i:s", strtotime($sdate));
$e = date("Y-m-d H:i:s", strtotime($edate));


$loan_inters = $app->loan_interest_free_paid();
$am = 0;
foreach ($loan_inters as $key => $values) {
    $cc = $am += $values->amountsxxx;
}

$principal_report = $app->cummulative_paid_months($s, $e);

//total given loans
$principal_report222 = $app->cummulative_loans_by_month_care($s, $e);

$loan_taken = $app->cummulative_loans($s, $e);
$loan_taken12 = $app->cummulative_loans_by_month($s, $e);


$l_interest = $app->l_interest($s, $e);
$loan_unpaid = $app->cummulative_dbt($s, $e);
$loan_inte = $app->inteest_dbt($s, $e);


?>
<!doctype html>
<html lang="en">
<head>
    <title>Loan Management</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">

    <link rel="stylesheet" href="assets/vendor/jquery-datatable/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedcolumns.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedheader.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/sweetalert/sweetalert.css"/>
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
    <style>
        td.details-control {
            background: url('assets/images/details_open.png') no-repeat center center;
            cursor: pointer;
        }
        tr.shown td.details-control {
            background: url('assets/images/details_close.png') no-repeat center center;
        }
    </style>
    <!-- Print styles. -->
    <style type="text/css" media="print">

        div#DivIdToPrint {
            display: inline;
        }
    </style>
</head>

<body class="theme-blue">

<!-- Page Loader -->
<div class="page-loader-wrapper">
    <div class="loader">
        <div class="m-t-30"><img src="logo.png" width="48" height="48" alt="Daros"></div>
        <p>Please wait...</p>
    </div>
</div>
<!-- Overlay For Sidebars -->

<div id="wrapper">

    <?php
    include_once "inc/header.php";
    ?>

    <?php
    include_once "inc/sidebar.php";
    ?>

    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a>Cumulative Reports</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard"><i class="fa fa-home fa-lg"></i></a></li>
                            <li class="breadcrumb-item active">Manage Loan</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card" id="DivIdToPrint">
                        <div class="header">
                            <button class="fa-pull-right btn btn-primary m-l-30 font-weight-bold" id="ccv"
                                    onclick='printContent("DivIdToPrint");'>Print Report
                            </button>
                            <br>
                        </div>


                        <div class="card">
                            <div class="body w_user" style="font-weight: bold;color: black;font-size: 20px">
                                <img class="" src="logo.png"
                                     alt="" style="height: 111px;">
                                <div class="wid-u-info">
                                    <h5 style="font-weight: bold;color: black;font-size: 29px">Cumulative Reports For The Week</h5>
                                    <p class="text-muted m-b-0">Loan Reports
                                        <br>From <?php echo $newDate = date("d-m-Y:h:i:s", strtotime($s)); ?> <span
                                                class="text-danger">To</span> <?php echo $newDate = date("d-m-Y:h:i:s", strtotime($e)); ?>
                                    </p>

                                </div>
                                <hr>
                                <div class="row">
                                    
                                     <div class="col-3">
                                        <small class="font-weight-bold" style="font-size: 15px"> Outstanding Principal BF
                                            Loans</small>
                                        <h5 class="m-b-0">₦<?= number_format(62021909); ?></h5>

                                    </div>
                                    
                                    
                                    <div class="col-3">
                                        <small class="font-weight-bold" style="font-size: 15px"> Total Given
                                            Loans</small>
                                        <h5 class="m-b-0">₦<?php $given = $principal_report222->loan_taken;  echo number_format($given); ?></h5>
                                    </div>

                                    <div class="col-3">
                                        <small class="font-weight-bold" style="font-size: 15px">Total Paid
                                            Principal</small>
                                        <h5 class="m-b-0">₦<?php $repaid = $principal_report->amounts; echo number_format($repaid); ?></h5>

                                    </div>


                                    <div class="col-3">
                                        <small class="font-weight-bold" style="font-size: 15px"> Outstanding
                                            Principal</small>
                                        <h5 class="m-b-0">
                                            ₦<?php $sg = abs($given+62021909-$repaid);
                                            echo number_format($sg); ?></h5>

                                    </div>

                                    <div class="col-2">
                                        <small class="font-weight-bold" style="font-size: 15px">Printed date</small>
                                        <h5 class="m-b-0"><?php $get_date = date('Y-m-d H:i:s');
                                            echo $newDate = date("d-m-Y:h:i:s", strtotime($get_date)); ?></h5>

                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="body">

                            <div class="table-responsive">
                                <table class="table table-striped table-hover js-basic-example dataTable table-customs">
                                    <thead>
                                    <tr style="font-weight: bold;color: black;font-size: 18px">
                                        <th>SN</th>
                                        <th>Account Name</th>
                                        <th>Amount Granted</th>
                                        <th>Amount RePaid</th>
                                        <th>Balance</th>
                                        <th>Date Granted</th>
                                        <th>Expiry Date</th>

                                        <!--                                        <th>Action</th>-->
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $get_total_info = $app->cumulative_reportads_months($s, $e);
                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        $sn++;
                                        ?>
                                        <tr class="dn_<?= $values->id; ?>"
                                            style="font-weight: bold;color: black;font-size: 14px">
                                            <td><?= $sn; ?></td>
                                            <td><?= ($values->c_name); ?></td>
                                            <td>₦<?= number_format($values->loan_amount, 2); ?></td>
                                            <td>₦<?= number_format($values->principal_paid, 2); ?></td>
                                            <td>₦<?php $sd = (abs($values->principal_paid - $values->loan_amount));
                                                echo number_format($sd, 2); ?></td>
                                            <td><?php echo $newDate = date("d-m-Y:h:i:s", strtotime($values->loan_date)); ?></td>
                                            <td><?php echo $newDate = date("d-m-Y:h:i:s", strtotime($values->due_date)); ?></td>

                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                    <tr style="font-weight: bold;color: black;font-size: 18px">
                                        <th></th>
                                        <th></th>
                                        <th>Total Given Loans :₦<?= number_format($loan_taken12->loan_taken); ?> </th>
                                        <th></th>
                                        <th>Total Paid Principal:₦<?= number_format($loan_taken12->loan_taken); ?> </th>
                                        <th></th>

                                        <!--                                        <th>Action</th>-->
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
</div>
<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/bundles/datatablescripts.bundle.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.print.min.js"></script>

<script src="assets/vendor/sweetalert/sweetalert.min.js"></script> <!-- SweetAlert Plugin Js -->
<script src="assets/vendor/toastr/toastr.js"></script>
<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/js/pages/tables/jquery-datatable.js"></script>
<script>
    $(document).ready(function () {

        $("#addplans").click(function () {
            const uid = $("#load_id").val();
            const cus_id = $("#cus_id").val();
            const btn = $("#del_stf");
            btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Creating...');
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
                const btn = $("#del_stf");
                btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
            } else {
                $.ajax({
                    url: "ajax/create_plans.php",
                    method: "GET",
                    data: {
                        uid: uid, cus_id: cus_id
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Plan Created!.', 'Success');
                            location.reload();
                        }
                    }
                });
            }
        });

        $(".delplans").click(function () {
            const uid = $(this).attr("data-id");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/del_loan_plan.php",
                    method: "GET",
                    data: {
                        uid: uid
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Plan Deleted!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);

                        }
                    }
                });
            }
        });


        $(".pay_principal").click(function () {
            const uid = $(this).attr("data-id");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/pay_principal.php",
                    method: "GET",
                    data: {
                        uid: uid
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Payment Updated!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }
        });


        $(".pay_interest").click(function () {
            const uid = $(this).attr("data-id");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/pay_interest.php",
                    method: "GET",
                    data: {
                        uid: uid
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Payment Updated!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }
        });

        $(".x_interest").click(function () {
            const uid = $(this).attr("data-id");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/x_interest.php",
                    method: "GET",
                    data: {
                        uid: uid
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Payment Updated!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }
        });

        $(".x_princiapl").click(function () {
            const uid = $(this).attr("data-id");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/x_principal.php",
                    method: "GET",
                    data: {
                        uid: uid
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Payment Updated!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }
        });


    });

    function printContent(el) {
        $("#ccv").hide();
        var restorepage = $('body').html();
        var printcontent = $('#' + el).clone();
        $('body').empty().html(printcontent);
        window.print();
        $('body').html(restorepage);
    }
</script>
</body>
</html>


<!--delete staff-->
<div class="modal fade" id="del_staff" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="title font-weight-bold" id="defaultModalLabel">Delete Staff</h6>
            </div>
            <span class="m-l-10 text-danger">Please note this action is permanent</span>
            <div class="modal-body">
                <div class="row clearfix">
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" class="form-control font-weight-bold" id="fullname"
                                   placeholder="" readonly>
                        </div>
                    </div>
                    <div class="col-12">
                        <input type="hidden" id="uid">
                        <input type="hidden" id="sb">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="del_stf" class="btn btn-primary font-weight-bold">Delete Staff</button>
                <button type="button" class="btn btn-danger font-weight-bold" data-dismiss="modal">X</button>
            </div>
        </div>
    </div>
</div>