<?php
include_once('cores.php');
include_once('db-config.php');
include_once('session.php');
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);

/**
 *
 */
class controller extends dbc {
    public $sun = 1000;
    public $api_key = apikey;





    public function fetch_query($query)
    {
        try {
            // Execute the SQL query and get the result set.
            $result = $this->run_query($query);

            // Check if the query execution was successful.
            if ($result) {
                // Initialize an empty array to store the fetched data.
                $data = [];

                // Fetch rows one by one from the result set and add them to the $data array.
                while ($row = $result->fetch_assoc()) {
                    // Sanitize each value in the row before adding it to the $data array.
                    $sanitized_row = [];
                    foreach ($row as $key => $value) {
                        // Use htmlentities to sanitize data for safe output in HTML context.
                        // This prevents XSS (Cross-Site Scripting) attacks when displaying data in HTML.
                        $sanitized_row[$key] = htmlspecialchars($value, ENT_QUOTES | ENT_HTML5, 'UTF-8');
                        // You can apply additional sanitization techniques as needed based on your specific requirements.
                    }
                    $data[] = $sanitized_row;
                }

                // Free the memory associated with the result set.
                // This is important to release resources and prevent memory leaks.
                $result->free();

                // Clean up by unsetting the $result variable.
                unset($result);

                // Return the fetched and sanitized data.
                return $data;
            } else {
                // Query execution failed, return an empty array or handle the error accordingly.
                return [];
            }
        } catch (Exception $e) {
            // Handle any exceptions that occur during database operations
            // For example, log the error or return an error message.
            // You can customize this according to your application's needs.
            return ['error' => $e->getMessage()];
        } finally {
            // Make sure to close the database connection in case of an error or successful execution.
            if (isset ($result)) {
                $result->free();
            }
        }
    }


    public function exc_query_db($query)
    {
        $run_qry = $this->run_query($query);
        if ($run_qry == true) {
            return "success";
        } else {
            return "failed";
        }
    }

    public function time_ago($timestamp)
{
    try {
        $current_time = new DateTime();
        $past_time = new DateTime($timestamp);
        $interval = $current_time->diff($past_time);

        if ($interval->y > 0) {
            return $interval->y . " year" . ($interval->y > 1 ? 's' : '') . " ago";
        } elseif ($interval->m > 0) {
            return $interval->m . " month" . ($interval->m > 1 ? 's' : '') . " ago";
        } elseif ($interval->d > 0) {
            return $interval->d . " day" . ($interval->d > 1 ? 's' : '') . " ago";
        } elseif ($interval->h > 0) {
            return $interval->h . " hour" . ($interval->h > 1 ? 's' : '') . " ago";
        } elseif ($interval->i > 0) {
            return $interval->i . " minute" . ($interval->i > 1 ? 's' : '') . " ago";
        } else {
            return "Just now";
        }
    } catch (Exception $e) {
        return "Invalid timestamp";
    }
}

function isDateInRange($date, $startDate, $endDate) {
    // Convert dates to Unix timestamp
    $dateTimestamp = strtotime($date);
    $startTimestamp = strtotime($startDate);
    $endTimestamp = strtotime($endDate);

    // Check if date is within the range
    if ($dateTimestamp >= $startTimestamp && $dateTimestamp <= $endTimestamp) {
        return true;
    } else {
        return false;
    }
}
















    
    
    
      public function all_customerr_loans_total() {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(total_loan) AS total_loan FROM customer where loan_type='Regular'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->total_loan = $row['total_loan'];
        $user_list[] = $obj;
        return $obj;
    }
    
    public function loan_updated() {
        $query = "SELECT id,SUM(total_loan)as loan_taken,SUM(loan_paid)as total_paid, SUM(balance) as balance FROM `customer`";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $obj->total_paid = $row['total_paid'];
        $obj->balance = $row['balance'];
        $user_list[] = $obj;
        return $obj;
    }

    
    
    public function cummulative_paid_weeks_free($s, $e)
    {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and principal_paid_date>='$s' and principal_paid_date <='$e' and loan_types='0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }
    
       
    public function cummulative_loans_by_weeks_free($s, $e)
    {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type='Interest Free' and loan_date>='$s' and loan_date <='$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }
    
    public function cummulative_loans_by_backs_free($s, $e)
    {
        $get_date = date('Y/M/D');
         //$query = "SELECT SUM(loan_amount) AS loan_bf FROM loans where loan_type!='Interest Free' and (loan_date BETWEEN '2023-06-00 00:00:00' AND '$s')";
         $query = "SELECT SUM(loan_amount) AS loan_bf FROM loans where loan_type='Interest Free' and loan_date>'2023-05-31 00:00:00' AND loan_date<'$s'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_bf = $row['loan_bf'];
        $user_list[] = $obj;
        return $obj;

    }
    
    
    
    public function cummulative_paid_weeks_prev_free($s, $e)
    {
        $get_date = date('Y/M/D');
         $query = "SELECT SUM(principal) AS principal_paid_prev FROM repayment where principal_paid='paid' and auto_transaction='1' and principal_paid_date>'2023-06-01 00:00:00' and principal_paid_date <'$s' and loan_types='0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->principal_paid_prev = $row['principal_paid_prev'];
        $user_list[] = $obj;
        return $obj;
    }
    
    public function cummulative_loans_free($s, $e)
    {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type='Interest Free' and loan_date >'2022-12-31'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }
    
    
    
    public function cummulative_loans_by_month_free($s, $e)
    {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type='Interest Free' and loan_date >= '$s' and loan_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }
    
    
    public function cumulative_reportads_months_free($s, $e)
    {
        $query = "SELECT * FROM loans WHERE  loan_date >= '$s' and loan_date <= '$e' and loan_type='Interest Free'";
        $qx = $this->run_query($query);
        $user_list = array();
        while ($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];

            if ($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            $get_paid = $this->check_all_principal($row['id']);
            $obj->principal_paid = $get_paid->principal_paid;

            if ($obj->id == 0) {
                $obj->interest_paid = '0';
            } else {
                $get_paid = $this->check_all_interest($row['id']);
                $obj->interest_paid = $get_paid->interest_paid;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }


    
    

    
    
    
    

    /** function to logout a user **/
    public function logout() {
        // remove all session variables
        session_unset();
        // destroy the session
        session_destroy();
    }

    /** function to check if a user is logged in **/
    public function checkLogin() {
        if(isset($_SESSION['login_user'])) {
            return 'logged';
        } else {
            return 'nau';
        }
    }

    public function delete_loan_ne($uid) {
        $query = "delete from loans where id='$uid'";
        return $this->runner($query);
    }

    public function del_banks_statement($code) {
        $query1 = "delete from bank_statement where dcode='$code'";
        return $this->runner($query1);
    }


    public function getlastbalnce($s, $rtype) {
        $query = "select * from bank_statement where posted_dated<'$s' and bank_id=$rtype and auto_transaction='1' order by id desc limit 1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function runner($query) {
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //user login
    public function auth_users($email, $password) {
        $query = "select * from staffs_accounts where email='$email' AND password='$password'";
        $run_query = $this->run_query($query);
        if($this->get_number_of_row($run_query) == 1) {
            $data = $this->get_result($run_query);
            $_SESSION['login_user'] = $data['id']; // Initializing Session
            $_SESSION['email'] = $data['email']; // Initializing Session
            return "success";
        } else {
            return "Invalid";
        }
    }

    //All user info sorted by id
    public function get_user_infos($id) {
        $query = "select * from staffs_accounts where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->user_id = $row['id'];
        $obj->email = $row['email'];
        $obj->fullname = $row['fullname'];
        return $obj;
    }

    //vt rp
    public function rt_rost($s, $e) {
        $query = "select * from vault_report where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->balance = $row['balance'];
            $obj->date_cr = $row['date_cr'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    /** function to reduce the lenght of a string **/
    public function stringFormat($string, $len) {
        if(strlen($string) > $len) {
            return substr($string, 0, $len).'...';
        } else {
            return $string;
        }
    }

    public function add_customer($tittle, $c_name, $sex, $work_center, $dpt, $work_address, $home_address, $cphone, $cemail, $marketer) {
        $pwd_gen = uniqid();
        $get_date = date('m/d/y');
        $query = "INSERT INTO `customer` (`id`, `tittle`, `c_name`, `sex`, `work_center`, `dpt`, `work_address`, `home_address`, `cphone`, `cemail`, `marketer`) VALUES (NULL, '$tittle', '$c_name', '$sex', '$work_center', '$dpt', '$work_address', '$home_address', '$cphone', '$cemail','$marketer');
";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function add_bansks($bn, $acn, $bads) {
        $pwd_gen = uniqid();
        $get_date = date('m/d/y');
        $query = "INSERT INTO `banks` (`id`, `bank_name`, `account_no`, `bank_address`, `status`, `date_created`) VALUES (NULL, '$bn', '$acn', '$bads', '0', '$get_date');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function axnx($bn) {
        $query = "INSERT INTO `despense_account` (`id`, `account_name`) VALUES (NULL,'$bn');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function add_plans($uid, $cus_id) {
        $pwd_gen = uniqid();
        $get_date = date('m/d/y');
        $query = "INSERT INTO `repayment` (`id`, `loan_id`,`customer_id`) VALUES (NULL,'$uid','$cus_id')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }



    public function loans_interest_reports_free($rtype, $s, $e) {
         $query = "SELECT * FROM `repayment` WHERE interest_paid='paid' and interest_paid_date >= '$s' and interest_paid_date <= '$e' and auto_transaction='1' and loan_types='0' and rev_status=1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->due_date = $row['due_date'];
            $obj->interest_paid = $row['interest_paid'];
            $obj->principal_paid = $row['principal_paid'];

            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];
            $obj->loan_id = $row['loan_id'];
            $obj->entered_by = $row['entered_by'];
            $obj->status = $row['status'];

            if($obj->customer_id == '') {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }
            if($obj->loan_id == 0) {
                $obj->loan_amount = '0';
            } else {
                $get_work_cen = $this->getloaninfo($row['loan_id']);
                $obj->loan_amount = $get_work_cen->loan_amount;
            }
            if($obj->customer_id == '' && $obj->loan_id == 0) {
                $obj->cbal = 0;
            } else {
                $get_work_cenx = $this->principal_report_db($row['customer_id'], $row['loan_id']);
                $obj->cbal = $get_work_cenx->cbal;
            }
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function interest_report_free($s, $e) {
        $query = "SELECT SUM(interest) AS principal_paid FROM repayment where interest_paid='paid' and interest_paid_date >= '$s' and interest_paid_date <= '$e' and auto_transaction='1' and loan_types='0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }


    public function principal_report_free($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid'  and principal_paid_date >= '$s' and principal_paid_date <= '$e' and auto_transaction='1' and loan_types='0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amountsed = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }


    public function proved_aacounts($id) {
        $query = "select * from bank_statement where bank_id=$id and auto_transaction='1' order by id desc limit 1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->description = $row['description'];
        $obj->dr = $row['dr'];
        $obj->cr = $row['cr'];
        $obj->date_cr = $row['date_cr'];
        $obj->balance = $row['balance'];
        return $obj;
    }

    public function add_trials($accname, $description) {
        $pwd_gen = uniqid();
        $get_date = date('m/d/y');
        $query = "INSERT INTO `trial_balance_cats` (`id`, `cats`, `description`, `date_added`) VALUES (NULL,'$accname','$description','$get_date');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function add_interests($interest, $amount) {
        $pwd_gen = uniqid();
        $get_date = date('m/d/y');
        $query = "INSERT INTO `interest` (`id`, `loans`,`amount`,`dated_cr`) VALUES (NULL,'$interest','$amount','$get_date');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }


    public function month_cols_repayment() {
        $get_date = date('Y/M/D');
        //$query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date >'2022-12-31'";
        $query = "SELECT SUM(principal) AS total_principal FROM repayment WHERE principal_paid='paid' and MONTH(principal_paid_date) =MONTH(now()) and YEAR(principal_paid_date) = YEAR(now())";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->total_principal = $row['total_principal'];
        $user_list[] = $obj;
        return $obj;

    }



    public function cummulative_paid_done($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and principal_paid_date >'2023-06-0' and loan_types='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }



    public function cummulative_paid_done_free($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and principal_paid_date >'2023-06-0' and loan_types='0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }





    //update the current B/F
    public function cummulative_loans_by_weeks_bf($s) {
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date <='$s' and loan_date>'00-06-2023:12:00:00'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;
    }



    public function cummulative_loans_by_m($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date>='2023-06-0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }


    public function cummulative_loans_by_m_free($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type='Interest Free' and loan_date>='2023-06-0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }






    public function month_cols() {
        $get_date = date('Y/M/D');
        //$query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date >'2022-12-31'";
        $query = "SELECT SUM(loan_amount) AS total_sum FROM loans WHERE loan_type!='Interest Free' and MONTH(loan_date) = MONTH(CURDATE()) AND YEAR(loan_date) = YEAR(CURDATE())";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->total_sum = $row['total_sum'];
        $user_list[] = $obj;
        return $obj;

    }




    public function month_cols_free() {
        $get_date = date('Y/M/D');
        //$query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date >'2022-12-31'";
        $query = "SELECT SUM(loan_amount) AS total_sum FROM loans WHERE loan_type='Interest Free' and MONTH(loan_date) = MONTH(CURDATE()) AND YEAR(loan_date) = YEAR(CURDATE())";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->total_sum = $row['total_sum'];
        $user_list[] = $obj;
        return $obj;

    }


    public function add_dptsn($dpt) {
        $get_date = date('m/d/y');
        $query = "INSERT INTO `department` (`id`, `dpt`,`dated_added`) VALUES (NULL,'$dpt','$get_date');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function add_center($wc, $work_center) {
        $pwd_gen = uniqid();
        $get_date = date('m/d/y');
        $query = "INSERT INTO `work_center` (`id`, `center_name`, `center_code`, `date_created`, `status`) VALUES (NULL, '$wc', '$work_center', '$get_date', '0');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function add_e_category($ec) {
        $pwd_gen = uniqid();
        $get_date = date('m/d/y');
        $query = "INSERT INTO `expenses` (`id`, `expenese_name`, `cr_dated`) VALUES (NULL, '$ec', '$get_date');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

   

    public function add_es($dc, $cat, $amount, $cdate, $new_account, $fullname, $rand, $user_id, $bank_id, $bank_name, $posted) {
        $decode = rand(123456, 12345678);
        $acc_types = $cat;
        $pwd_gen = uniqid();
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `expenses_data` (`id`, `date_added`, `description`, `type`, `account`, `status`, `dr`, `balance`, `by_user`, `dcode`, `types`, `bank_id`, `approved_by`, `auto_transaction`) VALUES (NULL, '$cdate', '$dc from $bank_name acc', '$cat', '0', '0', '$amount','$new_account','$fullname','$rand','0','$bank_id','bank','0');";

        $query1 = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`, `description`, `balance`, `dcode`, `trans_types`, `approved_by`, `auto_transaction`,`posted_dated`) VALUES (NULL, NULL, NULL, '$amount', NULL, '$cdate', '$bank_id', NULL, '$dc from $bank_name acc', '$new_account', '$rand','$acc_types','bank','0','$posted')";

        //$query2 = "update banks set bal='$new_account' where id='$bank_id'";
        //cash day report
        $query3 = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `balance`, `trans_date`, `status`, `dcode`) VALUES (NULL, '$dc from $bank_name acc', '$user_id', '$amount', NULL, '$new_account', '$get_date', NULL, '$rand');";
        //day expenses reports
        $query4 = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `balance`, `trans_date`, `status`, `dcode`) VALUES (NULL, '$dc to expenses acc', '$user_id', '0', $amount, '$new_account', '$get_date', NULL, '$rand');";

        $run_qry = $this->run_query($query);
        $run_qry1 = $this->run_query($query1);
        //$run_qry2 = $this->run_query($query2);
        $run_qry3 = $this->run_query($query3);
        $run_qry4 = $this->run_query($query4);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }


    public function inter_banks($rand, $new_acc_bal_from, $new_acc_bal_to, $bank_id_from, $bank_id_to, $amount, $cdate, $dc, $posted) {
        $pwd_gen = uniqid();
        $get_date = date('Y-m-d H:i:s');

        $cdate = date("Y-m-d H:i:s", strtotime($cdate));
        //to
        $query1 = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`, `description`, `balance`, `dcode`, `inter_bank_status`, `auto_transaction`,`from_bank`, `to_bank`,`posted_dated`) VALUES (NULL, NULL, NULL, '0', '$amount', '$cdate', '$bank_id_to', NULL, '$dc', '$new_acc_bal_to', '$rand','1','0','$bank_id_from','$bank_id_to','$posted');";

        //from
        $query11 = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`, `description`, `balance`, `dcode`, `inter_bank_status`, `auto_transaction`,`from_bank`, `to_bank`,`posted_dated`) VALUES (NULL, NULL, NULL, '$amount', NULL, '$cdate', '$bank_id_from', NULL, '$dc', '$new_acc_bal_from', '$rand','1','0','$bank_id_from','$bank_id_to','$posted');";

        //$query = "update banks set bal='$new_acc_bal_from' where id='$bank_id_from'";

        //$query2 = "update banks set bal='$new_acc_bal_to' where id='$bank_id_to'";


        $run_qry1 = $this->run_query($query1);
        $query11 = $this->run_query($query11);

        //$run_qry = $this->run_query($query);
        //$run_qry2 = $this->run_query($query2);

        if($run_qry1 == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //back up
    public function inter_banksxxxxx($new_acc_bal_from, $new_acc_bal_to, $bank_id_from, $bank_id_to, $amount, $cdate, $dc) {
        $pwd_gen = uniqid();
        $get_date = date('Y-m-d H:i:s');

        $cdate = date("Y-m-d H:i:s", strtotime($cdate));
        //to
        $query1 = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`, `description`, `balance`, `dcode`) VALUES (NULL, NULL, NULL, '0', '$amount', '$cdate', '$bank_id_to', NULL, '$dc', '$new_acc_bal_to', '0');";

        //from
        $query11 = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`, `description`, `balance`, `dcode`) VALUES (NULL, NULL, NULL, '$amount', NULL, '$cdate', '$bank_id_from', NULL, '$dc', '$new_acc_bal_from', '0');";

        $query = "update banks set bal='$new_acc_bal_from' where id='$bank_id_from'";

        $query2 = "update banks set bal='$new_acc_bal_to' where id='$bank_id_to'";

        $run_qry = $this->run_query($query);
        $run_qry1 = $this->run_query($query1);
        $run_qry2 = $this->run_query($query2);
        $query11 = $this->run_query($query11);

        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }



    public function add_e($dc, $cat, $amount, $cdate, $new_account, $fullname, $rand, $user_id) {
        $pwd_gen = rand(123456, 12345678);
        $get_dates = date(strtotime('Y-m-d H:i:s'));
        //$get_date = date('Y-m-d H:i:s', $get_dates);
        $query = "INSERT INTO `expenses_data` (`id`, `date_added`, `description`, `type`, `account`, `status`, `dr`, `balance`, `by_user`, `dcode`, `types`, `trans_types`,`approved_by`,`auto_transaction`) VALUES (NULL, '$cdate', '$dc', '$cat', '0', '0', '$amount','$new_account','$fullname','$pwd_gen','1','4','cash','0');";
        $query1 = "INSERT INTO `cash_report` (`id`, `description`, `transaction_id`, `cr`, `dr`, `balance`, `date_cr`, `dcode`,`trans_types`,`approved_by`,`auto_transaction`) VALUES (NULL,'$dc', '0', '$amount', '0','$new_account','$cdate','$pwd_gen','4','cash','0')";
        //$query2 = "UPDATE `cash_account` SET `balance` = '$new_account' WHERE `cash_account`.`id` ='1'";

        //cash day report
        $query3 = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `balance`, `trans_date`, `status`, `dcode`) VALUES (NULL, '$dc from cash acc', '$user_id', '$amount', NULL, '$new_account', '$cdate', NULL, '$pwd_gen');";
        //day expenses reports
        $query4 = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `balance`, `trans_date`, `status`, `dcode`) VALUES (NULL, '$dc to expenses acc', '$user_id', '0', $amount, '$new_account', '$cdate', NULL, '$pwd_gen');";

        $run_qry = $this->run_query($query);
        $run_qry1 = $this->run_query($query1);
        //$run_qry2 = $this->run_query($query2);
        $run_qry3 = $this->run_query($query3);
        $run_qry4 = $this->run_query($query4);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function add_sus_e($dc, $cat, $amount, $cdate, $new_account, $fullname, $rand, $user_id) {
        $pwd_gen = uniqid();
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `expenses_data` (`id`, `date_added`, `description`, `type`, `account`, `status`, `cr`, `balance`, `by_user`, `dcode`) VALUES (NULL, '$cdate', '$dc', '$cat', '0', '0', '$amount','$new_account','$fullname','$rand');";
        $query1 = "INSERT INTO `cash_report` (`id`, `description`, `transaction_id`, `cr`, `dr`, `balance`, `date_cr`, `dcode`) VALUES (NULL, '$dc', '0', '$amount', '0','$new_account','$cdate','$rand')";
        $query2 = "UPDATE `cash_account` SET `balance` = '$new_account' WHERE `cash_account`.`id` ='1'";
        //cash day report
        $query3 = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `balance`, `trans_date`, `status`, `dcode`) VALUES (NULL, '$dc from cash acc', '$user_id', '$amount', NULL, '$new_account', '$get_date', NULL, '$rand');";
        //day expenses reports
        $query4 = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `balance`, `trans_date`, `status`, `dcode`) VALUES (NULL, '$dc to expenses acc', '$user_id', '0', $amount, '$new_account', '$get_date', NULL, '$rand');";

        $run_qry = $this->run_query($query);
        $run_qry1 = $this->run_query($query1);
        $run_qry2 = $this->run_query($query2);
        $run_qry3 = $this->run_query($query3);
        $run_qry4 = $this->run_query($query4);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function d_report1($amount, $cname, $bankid, $status, $user_id, $rand) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `trans_date`, `status`, `balance`, `dcode`) VALUES (NULL, 'Disburse Loan -$cname', '$user_id', NULL, '$amount','$get_date', NULL,'$amount','$rand')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function bf_fk($hos_key) {
        $query = "SELECT * FROM staffs where host_key='$hos_key'";
        $q = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($q)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->fn = $row['fn'];
            $obj->ln = $row['ln'];
            $obj->email = $row['email'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function d_report2($amount, $cname, $bankid, $status, $user_id, $due_date, $rand) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `trans_date`, `status`, `balance`, `dcode`) VALUES (NULL, 'Loan Start $get_date - $due_date -  $cname', '$user_id', '$amount', '0','$get_date', NULL,'0','$rand')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //Add New staff
    public function add_staff($fullname, $position, $department, $email, $address, $phone, $gender, $work_center) {
        $pwd_gen = uniqid();
        $get_date = date('m/d/y');
        $query = "INSERT INTO `staffs_accounts` (`id`, `fullname`, `postion`, `department`, `email`, `password`, `address`, `phone`, `gender`, `work_center`) VALUES (NULL, '$fullname', '$position', '$department', '$email', '$pwd_gen','$address','$phone','$gender','$work_center');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function loan_grant($rtype, $s, $e) {
        $query = "SELECT * FROM `loans` WHERE center_id='$rtype' and loan_date >= '$s' and loan_date <= '$e'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $get_work_cen = $this->edit_customer($row['customer_id']);
            $obj->c_name = $get_work_cen->c_name;
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function loan_interest_free($s, $e) {
        $query = "SELECT * FROM `loans` WHERE loan_type='Interest Free' and loan_date >= '$s' and loan_date <= '$e'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $get_work_cen = $this->edit_customer($row['customer_id']);
            $obj->c_name = $get_work_cen->c_name;
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function sum_free_lonas($s, $e) {
        $query = "SELECT SUM(loan_amount) AS xc FROM loans WHERE status='0' and loan_type='Interest Free' and loan_date>='$s' and loan_date <='$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->xc = $row['xc'];
        $user_list[] = $obj;
        return $obj;
    }


    public function lc_total_work_center($rtype, $s, $e) {
        $query = "SELECT SUM(loan_amount) AS xc FROM loans WHERE status='0' and center_id='$rtype' and loan_date>='$s' and loan_date <='$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->xc = $row['xc'];
        $user_list[] = $obj;
        return $obj;
    }

    public function grant_loans_by_centers($rtype, $s, $e) {
        $query = "SELECT loans.id,loans.customer_id,loans.center_id,customer.c_name, repayment.cheque_amount,repayment.principal,repayment.interest,repayment.due_date FROM customer,loans,repayment WHERE loans.id=repayment.loan_id AND customer.id=repayment.customer_id AND loans.center_id='$rtype' AND repayment.due_date BETWEEN '$s' AND '$e' ORDER BY `loans`.`customer_id` ASC";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->cheque_amount = $row['cheque_amount'];
            $obj->interest = $row['interest'];
            $obj->c_name = $row['c_name'];
            $obj->due_date = $row['due_date'];

            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function loan_grantss($s, $e) {
        $query = "SELECT * FROM `loans` WHERE status=0 and loan_date >= '$s' and loan_date <= '$e' and loan_type!='Interest Free'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];

            $get_work_cen = $this->edit_customer($row['customer_id']);
            $obj->c_name = $get_work_cen->c_name;
            $user_list[] = $obj;
        }
        return $user_list;
    }

    //Add New staff
    public function new_loans($surety_address, $surety_dpt, $surety_phone, $surety_name, $rate, $loan_type, $due_date, $amount, $loan_date, $client, $wc, $cus_bankid, $bankid, $rand) {
        $pwd_gen = uniqid();
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `loans` (`id`, `customer_id`, `loan_date`, `loan_amount`, `Due_date`, `loan_type`, `rate`, `surety_name`, `surety_work_address`, `surety_phone`, `surety_dpt`,`center_id`,`cus_bankid`,`bank_id`,`dcode`) VALUES (NULL,'$client','$loan_date', '$amount', '$due_date', '$loan_type', '$rate', '$surety_name', '$surety_address', '$surety_phone', '$surety_dpt','$wc','$cus_bankid','$bankid','$rand')";
        $acc = "INSERT INTO `trial_account` (`id`, `trial_cat_id`, `cr`, `dr`, `date_cr`, `status`) VALUES (NULL, '14', 0, $amount, '$get_date', '0')";
        $run_qry = $this->run_query($query);
        $run_acc = $this->run_query($acc);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //retrieve staff list from database to table
    public function new_record_info() {
        $query = "select * from staffs_accounts where status='1'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->fullname = $row['fullname'];
            $obj->position = $row['postion'];
            $obj->department = $row['department'];
            $obj->email = $row['email'];
            $obj->phone = $row['phone'];
            $obj->address = $row['address'];
            $obj->gender = $row['gender'];
            $obj->ban = $row['ban'];
            $obj->work_center = $row['work_center'];
            //get work center name
            $get_work_cen = $this->get_work_center($row['work_center']);
            $obj->center_name = $get_work_cen->center_name;

            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function loans_data() {
        $query = "select * from loans where status='0' order by id desc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];
            $obj->loan_type = $row['loan_type'];
            $obj->rate = $row['rate'];
            $obj->surety_name = $row['surety_name'];
            $obj->surety_work_address = $row['surety_work_address'];
            $obj->surety_phone = $row['surety_phone'];
            $obj->surety_dpt = $row['surety_dpt'];
            $obj->status = $row['status'];
            $obj->cus_bankid = $row['cus_bankid'];
            $obj->bank_id = $row['bank_id'];
            $obj->dcode = $row['dcode'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            if($obj->cus_bankid == 0) {
                $obj->bank_name = 'unset';
            } else {
                $get_work_cen = $this->get_work_bank($row['cus_bankid']);
                $obj->bank_name = $get_work_cen->bank_name;
            }
            if($obj->bank_id == 0) {
                $obj->bank_names = 'unset';
            } else {
                $get_work_cent = $this->get_work_bank($row['bank_id']);
                $obj->bank_names = $get_work_cent->bank_name;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function loans_data_new() {
        $query = "select * from loans where status='0' and status_new='0' order by id desc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];
            $obj->loan_type = $row['loan_type'];
            $obj->rate = $row['rate'];
            $obj->surety_name = $row['surety_name'];
            $obj->surety_work_address = $row['surety_work_address'];
            $obj->surety_phone = $row['surety_phone'];
            $obj->surety_dpt = $row['surety_dpt'];
            $obj->status = $row['status'];
            $obj->cus_bankid = $row['cus_bankid'];
            $obj->bank_id = $row['bank_id'];
            $obj->dcode = $row['dcode'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            if($obj->cus_bankid == 0) {
                $obj->bank_name = 'unset';
            } else {
                $get_work_cen = $this->get_work_bank($row['cus_bankid']);
                $obj->bank_name = $get_work_cen->bank_name;
            }
            if($obj->bank_id == 0) {
                $obj->bank_names = 'unset';
            } else {
                $get_work_cent = $this->get_work_bank($row['bank_id']);
                $obj->bank_names = $get_work_cent->bank_name;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function loans_data_free() {
        $query = "select * from loans where status='0' and bad_debt='1' order by id desc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];
            $obj->loan_type = $row['loan_type'];
            $obj->rate = $row['rate'];
            $obj->surety_name = $row['surety_name'];
            $obj->surety_work_address = $row['surety_work_address'];
            $obj->surety_phone = $row['surety_phone'];
            $obj->surety_dpt = $row['surety_dpt'];
            $obj->status = $row['status'];
            $obj->cus_bankid = $row['cus_bankid'];
            $obj->bank_id = $row['bank_id'];
            $obj->dcode = $row['dcode'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            if($obj->cus_bankid == 0) {
                $obj->bank_name = 'unset';
            } else {
                $get_work_cen = $this->get_work_bank($row['cus_bankid']);
                $obj->bank_name = $get_work_cen->bank_name;
            }
            if($obj->bank_id == 0) {
                $obj->bank_names = 'unset';
            } else {
                $get_work_cent = $this->get_work_bank($row['bank_id']);
                $obj->bank_names = $get_work_cent->bank_name;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function loans_data_frees() {
        $query = "select * from loans where status='0' and loan_type='Interest Free' order by id desc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];
            $obj->loan_type = $row['loan_type'];
            $obj->rate = $row['rate'];
            $obj->surety_name = $row['surety_name'];
            $obj->surety_work_address = $row['surety_work_address'];
            $obj->surety_phone = $row['surety_phone'];
            $obj->surety_dpt = $row['surety_dpt'];
            $obj->status = $row['status'];
            $obj->cus_bankid = $row['cus_bankid'];
            $obj->bank_id = $row['bank_id'];
            $obj->dcode = $row['dcode'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            if($obj->cus_bankid == 0) {
                $obj->bank_name = 'unset';
            } else {
                $get_work_cen = $this->get_work_bank($row['cus_bankid']);
                $obj->bank_name = $get_work_cen->bank_name;
            }
            if($obj->bank_id == 0) {
                $obj->bank_names = 'unset';
            } else {
                $get_work_cent = $this->get_work_bank($row['bank_id']);
                $obj->bank_names = $get_work_cent->bank_name;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function loans_repayment($loan_id) {
        $query = "select * from repayment where customer_id='$loan_id' and status=0";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->due_date = $row['due_date'];
            $obj->interest_paid = $row['interest_paid'];
            $obj->principal_paid = $row['principal_paid'];

            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];
            $obj->loan_id = $row['loan_id'];
            $obj->entered_by = $row['entered_by'];
            $obj->status = $row['status'];
            $obj->bank_id = $row['bank_id'];
            $obj->method_pay = $row['method_pay'];
            $obj->cheque_amount = $row['cheque_amount'];
            $obj->dcode = $row['dcode'];
            $obj->description = $row['description'];
            $obj->posted_dated = $row['posted_dated'];
            $obj->rev_status = $row['rev_status'];


            if($obj->bank_id == 0) {
                $obj->bank_name = 'Unassigned';
            } else {
                $get_work_bank = $this->work_bank($row['bank_id']);
                $obj->bank_name = $get_work_bank->bank_name;
            }
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function refubsd($id) {
        $query = "select * from customer_account where customer_id='$id'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->cr = $row['cr'];
            $obj->dr = $row['dr'];
            $obj->created_date = $row['created_date'];
            $obj->descriptions = $row['descriptions'];


            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function get_interst_free() {
        $query = "select * from customer where loan_type='Interest Free'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->c_name = $row['c_name'];

            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function cus_statement($id) {
        $query = "select * from loans where customer_id='$id'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->loan_date = $row['loan_date'];
            $obj->created_date = $row['created_date'];
            $obj->descriptions = $row['descriptions'];


            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function loans_sc($loan_id) {
        $query = "select * from repayment where status='0' and loan_id='$loan_id' and auto_transaction=1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->due_date = $row['due_date'];
            $obj->interest_paid = $row['interest_paid'];
            $obj->principal_paid = $row['principal_paid'];

            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];
            $obj->loan_id = $row['loan_id'];
            $obj->entered_by = $row['entered_by'];
            $obj->status = $row['status'];
            $obj->bank_id = $row['bank_id'];
            $obj->method_pay = $row['method_pay'];
            $obj->cheque_amount = $row['cheque_amount'];
            $obj->dcode = $row['dcode'];

            if($obj->bank_id == 0) {
                $obj->bank_name = 'Unassigned';
            } else {
                $get_work_bank = $this->work_bank($row['bank_id']);
                $obj->bank_name = $get_work_bank->bank_name;
            }
            $user_list[] = $obj;
        }
        return $user_list;
    }


    //All user info sorted by id
    public function getloaninfo($id) {
        $query = "select * from loans where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->customer_id = $row['customer_id'];
        $obj->loan_date = $row['loan_date'];
        $obj->loan_amount = $row['loan_amount'];
        $obj->due_date = $row['Due_date'];
        $obj->loan_type = $row['loan_type'];
        $obj->rate = $row['rate'];
        $obj->surety_name = $row['surety_name'];
        $obj->surety_work_address = $row['surety_work_address'];
        $obj->surety_phone = $row['surety_phone'];
        $obj->surety_dpt = $row['surety_dpt'];
        $obj->status = $row['status'];
        $obj->bank_id = $row['bank_id'];
        $obj->cus_bankid = $row['cus_bankid'];

        if($obj->customer_id == 0) {
            $obj->c_name = 'unset';
        } else {
            $get_work_cen = $this->edit_customer($row['customer_id']);
            $obj->c_name = $get_work_cen->c_name;
        }
        return $obj;
    }

    public function loans_repayment_reports($rtype, $s, $e) {
        $query = "SELECT * FROM `repayment` WHERE principal_paid='paid' and principal_paid_date >= '$s' and principal_paid_date<= '$e' and auto_transaction='1' and loan_types='1'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->due_date = $row['due_date'];
            $obj->interest_paid = $row['interest_paid'];
            $obj->principal_paid = $row['principal_paid'];

            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];
            $obj->loan_id = $row['loan_id'];
            $obj->entered_by = $row['entered_by'];
            $obj->status = $row['status'];

            $get_work_cen = $this->edit_customer($row['customer_id']);
            $obj->c_name = $get_work_cen->c_name;

            $get_work_cen = $this->getloaninfo($row['loan_id']);
            $obj->loan_amount = $get_work_cen->loan_amount;

            //total repaid
            $get_work_cenx = $this->principal_report_db($row['customer_id'], $row['loan_id']);
            $obj->cbal = $get_work_cenx->cbal;

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function customer_account_history($s, $e) {
        $query = "select * from customer_account where created_date >= '$s' and created_date <= '$e'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->description = $row['descriptions'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->balance = $row['bal'];
            $obj->cr_date = $row['created_date'];

            $get_work_cen = $this->edit_customer($row['customer_id']);
            $obj->c_name = $get_work_cen->c_name;

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function cumulative_report($rtype, $s, $e) {
        $query = "SELECT * FROM `loans` WHERE  loan_date >= '$s' and loan_date <= '$e'";
        // $query = "SELECT * FROM `loans`";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            $get_paid = $this->check_all_principal($row['id']);
            $obj->principal_paid = $get_paid->principal_paid;

            if($obj->id == 0) {
                $obj->interest_paid = '0';
            } else {
                $get_paid = $this->check_all_interest($row['id']);
                $obj->interest_paid = $get_paid->interest_paid;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function banks_proved_sususpense_legal($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='27' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function proved_interest_freed($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='27' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function housing_proved_sheet($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='29' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function travel_proved_sheet($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='30' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function shopping_proved_sheet($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='32' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function medical_proved_sheet($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='33' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }



    public function solar_proved_sheet($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='34' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }




    public function cummulative_paid_current() {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and  MONTH(principal_paid_date) = MONTH(CURDATE()) AND YEAR(principal_paid_date) = YEAR(CURDATE()) and loan_types='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }


    public function cummulative_paid_current_free() {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and  MONTH(principal_paid_date) = MONTH(CURDATE()) AND YEAR(principal_paid_date) = YEAR(CURDATE()) and loan_types='0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }


    
    public function cummulative_paid_current_free_month() {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and  MONTH(principal_paid_date) = MONTH(CURDATE()) AND YEAR(principal_paid_date) = YEAR(CURDATE()) and loan_types='0' and rev_status='0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }




    public function total_colse() {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date >'2023-06-00'";
        // $query = "SELECT SUM(loan_amount) AS total_sum FROM loans WHERE loan_type!='Interest Free' and MONTH(loan_date) = MONTH(CURDATE()) AND YEAR(loan_date) = YEAR(CURDATE())";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->total_sum = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }




    public function total_colse_free() {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type='Interest Free' and loan_date >'2023-06-00'";
        // $query = "SELECT SUM(loan_amount) AS total_sum FROM loans WHERE loan_type!='Interest Free' and MONTH(loan_date) = MONTH(CURDATE()) AND YEAR(loan_date) = YEAR(CURDATE())";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->total_sum = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }



    public function equipment_proved_sheet($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='36' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }



    public function dstv_proved_sheet($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='31' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }



    public function banks_proved_sususpense_insurance($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='28' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }



    public function banks_proved_sususpense($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='24' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }



    public function banks_proved_cashaccount($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='21' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function banks_proved_votsss($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id='26' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function loan_repayment_approval() {
        $query = "SELECT * FROM `repayment` WHERE auto_transaction='0' and interest_paid='paid' and principal_paid='paid'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->cheque_amount = $row['cheque_amount'];
            $obj->method_pay = $row['method_pay'];
            $obj->loan_id = $row['loan_id'];
            $obj->bank_id = $row['bank_id'];
            $obj->dcode = $row['dcode'];
            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            if($obj->bank_id == 0) {
                $obj->bank_id = 'unset';
            } else {
                $bank_info = $this->bank_infos($row['bank_id']);
                $obj->bank_name = $bank_info->bank_name;

            }


            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function loan_repayment_check($rtype, $s, $e) {
        $query = "SELECT * FROM `repayment` WHERE auto_transaction='1' and due_date >= '$s' and due_date <= '$e' and loan_types=1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->cheque_amount = $row['cheque_amount'];
            $obj->method_pay = $row['method_pay'];
            $obj->loan_id = $row['loan_id'];
            $obj->due_date = $row['due_date'];
            $obj->bank_id = $row['bank_id'];
            $obj->dcode = $row['dcode'];
            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }


            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function loan_repayment_check_failed($rtype, $s, $e) {
        $query = "SELECT * FROM repayment WHERE principal_paid='unpaid' and due_date >= '$s' and due_date <= '$e' and status!=1 and cheque_amount!=0";

        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->cheque_amount = $row['cheque_amount'];
            $obj->method_pay = $row['method_pay'];
            $obj->loan_id = $row['loan_id'];
            $obj->due_date = $row['due_date'];
            $obj->bank_id = $row['bank_id'];
            $obj->dcode = $row['dcode'];
            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }


            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function cumulative_reportads() {
        $query = "SELECT * FROM loans where loan_type!='Interest Free'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            $get_paid = $this->check_all_principal($row['id']);
            $obj->principal_paid = $get_paid->principal_paid;

            if($obj->id == 0) {
                $obj->interest_paid = '0';
            } else {
                $get_paid = $this->check_all_interest($row['id']);
                $obj->interest_paid = $get_paid->interest_paid;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function cumulative_reportads_bad_bt() {
        $query = "SELECT * FROM loans where bad_debt='1'";
        // $query = "SELECT * FROM `loans`";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            $get_paid = $this->check_all_principal($row['id']);
            $obj->principal_paid = $get_paid->principal_paid;

            if($obj->id == 0) {
                $obj->interest_paid = '0';
            } else {
                $get_paid = $this->check_all_interest($row['id']);
                $obj->interest_paid = $get_paid->interest_paid;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function cumulative_reportadsfree() {
        $query = "SELECT * FROM loans where loan_type='Interest Free' group by customer_id";
        // $query = "SELECT * FROM `loans`";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
                $obj->total_loan = $get_work_cen->total_loan;
                $obj->loan_paid = $get_work_cen->loan_paid;
                $obj->balance = $get_work_cen->balance;
            }

            $get_paid = $this->check_all_principal($row['id']);
            $obj->principal_paid = $get_paid->principal_paid;

            if($obj->id == 0) {
                $obj->interest_paid = '0';
            } else {
                $get_paid = $this->check_all_interest($row['id']);
                $obj->interest_paid = $get_paid->interest_paid;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function cummulative_loans_by_month($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date >= '$s' and loan_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }


    public function cummulative_loans_by_month_care($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date>='2023-01-01 ' and loan_date <='$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }



    public function cummulative_loans_by_weeks($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date>='$s' and loan_date <='$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }



    public function cumulative_reportads_months($s, $e) {
        //$query = "SELECT * FROM loans WHERE  loan_date >= '$s' and loan_date <= '$e'";
        $query = "SELECT * FROM loans WHERE  loan_date >= '$s' and loan_date <= '$e' and loan_type!='Interest Free'";
        // $query = "SELECT * FROM `loans`";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->balance = $row['balance'];
            $obj->due_date = $row['Due_date'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }

            $get_paid = $this->check_all_principal($row['id']);
            $obj->principal_paid = $get_paid->principal_paid;

            if($obj->id == 0) {
                $obj->interest_paid = '0';
            } else {
                $get_paid = $this->check_all_interest($row['id']);
                $obj->interest_paid = $get_paid->interest_paid;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function check_all_principal($load_id) {
        $query = "SELECT SUM(principal) AS principal_paidz FROM repayment where loan_id='$load_id' and principal_paid='paid' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->principal_paid = $row['principal_paidz'];
        return $obj;
    }

    public function check_all_interest($load_id) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(interest) AS interest_paid FROM repayment where loan_id='$load_id' and interest_paid='paid' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->interest_paid = $row['interest_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    public function general_repayment_reports($rtype, $s, $e) {
        $query = "SELECT * FROM `repayment` WHERE  due_date >= '$s' and due_date <= '$e'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->due_date = $row['due_date'];
            $obj->interest_paid = $row['interest_paid'];
            $obj->principal_paid = $row['principal_paid'];

            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];
            $obj->loan_id = $row['loan_id'];
            $obj->entered_by = $row['entered_by'];
            $obj->status = $row['status'];

            $get_work_cen = $this->edit_customer($row['customer_id']);
            $obj->c_name = $get_work_cen->c_name;

            $get_work_cen = $this->getloaninfo($row['loan_id']);
            $obj->loan_amount = $get_work_cen->loan_amount;

            $get_work_cenx = $this->principal_report_db($row['customer_id'], $row['loan_id']);
            $obj->cbal = $get_work_cenx->cbal;

            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function interest_m($check_month) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(interest) AS mothly FROM repayment where MONTH(interest_paid_date)='$check_month' and interest_paid='paid' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->mothly = $row['mothly'];
        $user_list[] = $obj;
        return $obj;
    }

    public function sum_work_centers($rtype, $s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(repayment.interest) as total FROM customer,loans,repayment WHERE loans.id=repayment.loan_id AND customer.id=repayment.customer_id AND loans.center_id='$rtype' AND  repayment.due_date >= '$s' and repayment.due_date <= '$e'  ORDER BY `loans`.`customer_id` ASC";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->total = $row['total'];
        $user_list[] = $obj;
        return $obj;
    }

    public function pricv($check_month) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS mothly FROM repayment where MONTH(principal_paid_date)='$check_month' and principal_paid='paid' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->mothly = $row['mothly'];
        $user_list[] = $obj;
        return $obj;
    }

    public function cash_account_checked() {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(balance) AS cash_accountses FROM cash_account";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->balancex = $row['cash_accountses'];
        $user_list[] = $obj;
        return $obj;
    }


    public function suspenses_acx() {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(balance) AS despense_account FROM despense_account";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->balancexc = $row['despense_account'];
        $user_list[] = $obj;
        return $obj;
    }


    public function vault_xx() {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(balance) AS vault FROM vault";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->balancexcx = $row['vault'];
        $user_list[] = $obj;
        return $obj;
    }


    public function due_loans($check_day) {
        $query = "SELECT * FROM `repayment` WHERE MONTH(due_date)='$check_day' order by due_date asc ";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->due_date = $row['due_date'];
            $obj->interest_paid = $row['interest_paid'];
            $obj->principal_paid = $row['principal_paid'];

            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];
            $obj->loan_id = $row['loan_id'];
            $obj->entered_by = $row['entered_by'];
            $obj->status = $row['status'];
            $obj->cheque_amount = $row['cheque_amount'];

            if($obj->customer_id == 0) {
                $obj->customer_id = "Unset";
            } else {
                $student_house = $this->edit_customer($obj->customer_id);
                $obj->c_name = $student_house->c_name;
            }


            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function shedulesx($rtype, $s, $e) {
        $query = "SELECT * FROM `repayment` WHERE bank_id='$rtype' and due_date >= '$s' and due_date <= '$e')";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->due_date = $row['due_date'];
            $obj->interest_paid = $row['interest_paid'];
            $obj->principal_paid = $row['principal_paid'];

            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];
            $obj->loan_id = $row['loan_id'];
            $obj->entered_by = $row['entered_by'];
            $obj->status = $row['status'];

            $obj->cheque_amount = $row['cheque_amount'];

            if($obj->customer_id == 0) {
                $obj->customer_id = "na";
            } else {
                $student_house = $this->edit_customer($obj->customer_id);
                $obj->c_name = $student_house->c_name;
            }

            $get_work_cen = $this->getloaninfo($row['loan_id']);
            $obj->loan_amount = $get_work_cen->loan_amount;

            $get_work_cenx = $this->principal_report_db($row['customer_id'], $row['loan_id']);
            $obj->cbal = $get_work_cenx->cbal;

            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function loans_interest_reports($rtype, $s, $e) {
         $query = "SELECT * FROM `repayment` WHERE interest_paid='paid' and interest_paid_date >= '$s' and interest_paid_date <= '$e' and auto_transaction='1' and loan_types=1   and rev_status=0";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->due_date = $row['due_date'];
            $obj->interest_paid = $row['interest_paid'];
            $obj->principal_paid = $row['principal_paid'];

            $obj->interest_paid_date = $row['interest_paid_date'];
            $obj->principal_paid_date = $row['principal_paid_date'];
            $obj->loan_id = $row['loan_id'];
            $obj->entered_by = $row['entered_by'];
            $obj->status = $row['status'];

            if($obj->customer_id == '') {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
            }
            if($obj->loan_id == 0) {
                $obj->loan_amount = '0';
            } else {
                $get_work_cen = $this->getloaninfo($row['loan_id']);
                $obj->loan_amount = $get_work_cen->loan_amount;
            }
            if($obj->customer_id == '' && $obj->loan_id == 0) {
                $obj->cbal = 0;
            } else {
                $get_work_cenx = $this->principal_report_db($row['customer_id'], $row['loan_id']);
                $obj->cbal = $get_work_cenx->cbal;
            }
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function customer_data() {
        $query = "select * from customer where status='1' order by  c_name asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->tittle = $row['tittle'];
            $obj->c_name = $row['c_name'];
            $obj->sex = $row['sex'];
            $obj->work_center = $row['work_center'];
            $obj->work_address = $row['work_address'];
            $obj->home_address = $row['home_address'];
            $obj->cphone = $row['cphone'];
            $obj->cemail = $row['cemail'];
            $obj->dpt = $row['dpt'];
            $obj->status = $row['status'];
            $obj->marketer = $row['marketer'];
            $obj->createdDate = $row['createdDate'];
            //get work center name

            if($obj->work_center == 0) {
                $obj->center_name = 'Not Assigned';
            } else {
                $get_work_cen = $this->get_work_center($row['work_center']);
                $obj->center_name = $get_work_cen->center_name;
            }

            if($obj->marketer == 0) {
                $obj->fullname = "na";
            } else {
                $get_work_cenw = $this->statt($row['marketer']);
                $obj->fullname = $get_work_cenw->fullname;
            }


            $user_list[] = $obj;
        }
        return $user_list;
    }

    //All user info sorted by id
    public function get_work_center($id) {
        $query = "select * from work_center where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->center_name = $row['center_name'];
        $obj->center_code = $row['center_code'];
        $obj->date_created = $row['date_created'];

        return $obj;
    }



    public function despense_account($id) {
        $query = "select * from despense_account where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->account_name = $row['account_name'];
        $obj->balance = $row['balance'];

        return $obj;
    }

    public function cashout_account($id) {
        $query = "select * from despense_account where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->account_name = $row['account_name'];
        $obj->balance = $row['balance'];
        return $obj;
    }

    public function cash_acc() {
        $query = "select * from cash_account where id='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->balance = $row['balance'];
        return $obj;
    }

    public function bk_bal($id) {
        $query = "select * from banks where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->balance = $row['bal'];
        return $obj;
    }

    public function loans_sc_fixc($sid) {
        $query = "select * from customer_rp where cus_id='$sid' order by cr_date asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->cus_id = $row['cus_id'];
            $obj->cr_date = $row['cr_date'];
            $obj->description = $row['description'];
            $obj->interest = $row['interest'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function loans_sc_fix($sid) {
        $query = "select * from loans where customer_id='$sid'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->Due_date = $row['Due_date'];
            $obj->rate = $row['rate'];
            $obj->loan_type = $row['loan_type'];
            $obj->loan_desc = $row['loan_desc'];

            $obj->repayment = $this->rep_report($sid);

            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function rep_report($repid) {
        $query = "select * from repayment where customer_id='$repid' and principal_paid='paid'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->cheque_amount = $row['cheque_amount'];
            $obj->principal = $row['principal'];
            $obj->interest = $row['interest'];
            $obj->principal_paid_date = $row['principal_paid_date'];
            $obj->description = $row['description'];
            $obj->rev_status = $row['rev_status'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function suspense_balance() {
        $query = "select * from despense_account where id='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->balance = $row['balance'];
        return $obj;
    }

    //All user info sorted by id
    public function update_expenses($id) {
        $query = "select * from expenses_data where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->date_added = $row['date_added'];
        $obj->description = $row['description'];
        $obj->amount = $row['amount'];
        $obj->type = $row['type'];

        $hod_info = $this->get_expenses($row['type']);
        $obj->expenese_name = $hod_info->expenese_name;

        return $obj;
    }



    public function loanpaid_cus123($loan_id) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and customer_id='$loan_id' and rev_status=0";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;

    }

    public function get_loans_add($id) {
        $query = "select customer_id, sum(loan_amount) as loan_amount from loans where customer_id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->customer_id = $row['customer_id'];
        $obj->loan_amount = $row['loan_amount'];

        return $obj;
    }

    public function get_loans($id) {
        $query = "select * from loans where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->customer_id = $row['customer_id'];
        $obj->loan_date = $row['loan_date'];
        $obj->loan_amount = $row['loan_amount'];
        $obj->Due_date = $row['Due_date'];
        $obj->rate = $row['rate'];
        $obj->loan_type = $row['loan_type'];
        return $obj;
    }

    public function get_work_bank($id) {
        $query = "select * from banks where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->bank_name = $row['bank_name'];
        $obj->account_no = $row['account_no'];
        $obj->bank_address = $row['bank_address'];
        $obj->date_created = $row['date_created'];
        $obj->balance = $row['bal'];
        return $obj;
    }

    public function work_bank($id) {
        $query = "select * from banks where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->bank_name = $row['bank_name'];
        return $obj;
    }

    public function get_work_accounts($id) {
        $query = "select * from trial_balance_cats where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->cats = $row['cats'];
        $obj->description = $row['description'];
        return $obj;
    }


    public function get_dpt_id($id) {
        $query = "select * from department where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->cats = $row['dpt'];
        return $obj;
    }

    public function get_interest($id) {
        $query = "select * from interest where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->loans = $row['loans'];
        return $obj;
    }

    //All user info sorted by id
    public function edit_customer($id) {

        $query = "select * from customer where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->tittle = $row['tittle'];
        $obj->c_name = $row['c_name'];
        $obj->sex = $row['sex'];
        $obj->work_center = $row['work_center'];
        $obj->work_address = $row['work_address'];
        $obj->home_address = $row['home_address'];
        $obj->cphone = $row['cphone'];
        $obj->cemail = $row['cemail'];
        $obj->dpt = $row['dpt'];
        $obj->status = $row['status'];
        $obj->createdDate = $row['createdDate'];
        $obj->total_loan = $row['total_loan'];
        $obj->loan_paid = $row['loan_paid'];
        $obj->outstanding = $row['outstanding'];
        $obj->balance = $row['balance'];
        $obj->revs = $row['revs'];
        //get work center name

        if($obj->work_center == 0) {
            $obj->center_name = 'Not Assigned';
        } else {
            $get_work_cen = $this->get_work_center($row['work_center']);
            $obj->center_name = $get_work_cen->center_name;
        }

        //
//        $get_work_cen = $this->get_work_center($row['work_center']);
//        $obj->center_name = $get_work_cen->center_name;
        return $obj;
    }

    //All user info sorted by id
    public function staff_p($id) {
        $query = "select * from staff_position where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->position_name = $row['position_name'];
        return $obj;
    }

    //All user info sorted by id
    public function staff_dpt($id) {
        $query = "select * from department where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->dpt = $row['dpt'];
        return $obj;
    }

    public function lite_plans($id) {
        $query = "select * from repayment where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->principal = $row['principal'];
        $obj->interest = $row['interest'];
        $obj->due_date = $row['due_date'];
        $obj->interest_paid = $row['interest_paid'];
        $obj->principal_paid = $row['principal_paid'];
        $obj->interest_paid_date = $row['interest_paid_date'];
        $obj->principal_paid_date = $row['principal_paid_date'];
        $obj->loan_id = $row['loan_id'];
        $obj->status = $row['status'];
        $obj->cheque_amount = $row['cheque_amount'];
        $obj->bank_id = $row['bank_id'];
        $obj->description = $row['description'];
        $obj->posted_dated = $row['posted_dated'];
        return $obj;
    }

    //All user info sorted by id
    public function edit_staffs($id) {
        $query = "select * from staffs_accounts where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->fullname = $row['fullname'];
        $obj->position = $row['postion'];
        $obj->department = $row['department'];
        $obj->email = $row['email'];
        $obj->phone = $row['phone'];
        $obj->address = $row['address'];
        $obj->gender = $row['gender'];
        $obj->password = $row['password'];

        if($obj->position == 0) {
            $obj->position_name = 'Unassigned';
        } else {
            $get_positons = $this->staff_p($row['postion']);
            $obj->position_name = $get_positons->position_name;
        }

        if($obj->department == 0) {
            $obj->dpt = 'Unassigned';
        } else {
            $get_dpt = $this->staff_dpt($row['department']);
            $obj->dpt = $get_dpt->dpt;
        }
        return $obj;
    }


    //All user info sorted by id
    public function statt($id) {
        if(isset($id)) {
            $query = "select * from staffs_accounts where id='$id'";
        }
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->fullname = $row['fullname'];
        return $obj;
    }

    public function work_center() {
        $query = "select * from work_center where status=0";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->center_name = $row['center_name'];
            $obj->center_code = $row['center_code'];
            $obj->date_created = $row['date_created'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function expenses() {
        $query = "select * from expenses order by expenese_name asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->expenese_name = $row['expenese_name'];
            $obj->date_created = $row['cr_dated'];
            $obj->status = $row['status'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function expenses_data_pl($s, $e) {
        $query = "select type,cr,dr,date_added,description,account,balance,amount,id, sum(dr) as tal from expenses_data WHERE status='0' and rev!=1 and date_added >= '$s' and date_added <= '$e' and auto_transaction='1' and type not in (101205,30062,30031,30032,30030,30072,30080,101208,50107,101189,101193,50109,50114,101187,50110,101216,101209,101220) group by type";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->date_added = $row['date_added'];
            $obj->description = $row['description'];
            $obj->amount = $row['amount'];
            $obj->type = $row['type'];
            $obj->cr = $row['cr'];
            $obj->tal = $row['tal'];
            $obj->account = $row['account'];
            $obj->dr = $row['dr'];
            $obj->balance = $row['balance'];

            if($obj->type == 0) {
                $obj->expenese_name = 'unset';
            } else {
                $hod_info = $this->get_expenses($row['type']);
                $obj->expenese_name = $hod_info->expenese_name;
            }

            if($obj->account == 0) {
                $obj->account_name = 'unset';
            } else {
                $hod_info = $this->despense_account($row['account']);
                $obj->account_name = $hod_info->account_name;
            }


            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function expenses_data_s() {
        $query = "select * from expenses_data where status=0";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->date_added = $row['date_added'];
            $obj->description = $row['description'];
            $obj->amount = $row['amount'];
            $obj->type = $row['type'];
            $obj->cr = $row['cr'];
            $obj->account = $row['account'];
            $obj->dr = $row['dr'];
            $obj->balance = $row['balance'];
            $obj->dcode = $row['dcode'];
            $obj->types = $row['types'];
            $obj->bank_id = $row['bank_id'];
            $obj->rev = $row['rev'];

            $hod_info = $this->get_expenses($row['type']);
            $obj->expenese_name = $hod_info->expenese_name;

            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function res_point($s, $e) {
        $query = "SELECT SUM(amount) AS principal_paid FROM expenses_data and date_added >= '$s' and date_added <= '$e')";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    public function report_xx($s, $e) {

        $query = "SELECT SUM(cr) AS principal_paid FROM expenses_data where date_added >= '$s' and date_added <= '$e'";

        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    public function report_xxcc($s, $e) {
        $query = "SELECT SUM(dr) AS principal_paiddr FROM expenses_data where date_added >= '$s' and date_added <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paiddr'];
        $user_list[] = $obj;
        return $obj;
    }

    public function report_xxx($s, $e, $rtype) {
        $query = "SELECT SUM(cr) AS principal_paid FROM expenses_data where type='$rtype' and date_added >= '$s' and date_added <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    public function report_xxxdr($s, $e, $rtype) {
        $query = "SELECT SUM(dr) AS principal_paiddr FROM expenses_data where type='$rtype' and date_added >= '$s' and date_added <= '$e' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paiddr'];
        $user_list[] = $obj;
        return $obj;
    }

    public function expenses_data_ses($rtype, $s, $e) {
        $query = "SELECT * FROM `expenses_data` WHERE  status='0'and type='$rtype' and date_added >= '$s' and date_added <= '$e' and auto_transaction='1'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->date_added = $row['date_added'];
            $obj->description = $row['description'];
            $obj->amount = $row['cr'];
            $obj->dr = $row['dr'];
            $obj->type = $row['type'];
            $obj->by_user = $row['by_user'];

            if($obj->type == 0) {
                $obj->expenese_name = 'Null';
            } else {
                $hod_info = $this->get_expenses($row['type']);
                $obj->expenese_name = $hod_info->expenese_name;
            }
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function expenses_data_se($rtype, $s, $e) {
        $query = "SELECT * FROM `expenses_data` WHERE  status='0' and date_added >= '$s' and date_added <= '$e'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->date_added = $row['date_added'];
            $obj->description = $row['description'];
            $obj->cr = $row['cr'];
            $obj->dr = $row['dr'];
            $obj->type = $row['type'];
            $obj->by_user = $row['by_user'];

            if($obj->type == 0) {
                $obj->expenese_name = 'Null';
            } else {
                $hod_info = $this->get_expenses($row['type']);
                $obj->expenese_name = $hod_info->expenese_name;
            }
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function banks() {
        $query = "SELECT * FROM `banks` where status=0";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->bank_name = $row['bank_name'];
            $obj->account_no = $row['account_no'];
            $obj->bank_address = $row['bank_address'];
            $obj->date_created = $row['date_created'];
            $obj->bal = $row['bal'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function ex() {
        $query = "SELECT * FROM `despense_account` where status=0";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->bank_name = $row['account_name'];
            $obj->balance = $row['balance'];
            $obj->date_created = $row['date_created'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function account_types() {
        $query = "SELECT * FROM `trial_balance_cats` where status=0";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->cats = $row['cats'];
            $obj->description = $row['description'];
            $obj->date_added = $row['date_added'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function departments() {
        $query = "SELECT * FROM `department` where status=0";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->cats = $row['dpt'];
            $obj->date_added = $row['dated_added'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function interestx() {
        $query = "SELECT * FROM `interest` where status=0";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->loans = $row['loans'];
            $obj->amount = $row['amount'];
            $obj->date_added = $row['dated_cr'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function staff_position() {
        $query = "select * from staff_position";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->position_name = $row['position_name'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function staff_department_x() {
        $query = "select * from department";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->dpt = $row['dpt'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    //sum cr for vt
    public function cr_person($s, $e, $user_id) {
        $query = "SELECT SUM(cr) AS person_cr FROM day_reports where trans_date >= '$s' and trans_date <= '$e' and staff_id='$user_id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['person_cr'];
        $user_list[] = $obj;
        return $obj;

    }

    //sum cr for vt
    public function dr_person($s, $e, $user_id) {
        $query = "SELECT SUM(dr) AS person_dr FROM day_reports where trans_date >= '$s' and trans_date <= '$e' and staff_id='$user_id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['person_dr'];
        $user_list[] = $obj;
        return $obj;
    }


    //vt rp
    public function rt_rp($s, $e, $user_id) {
        //        $query = "select * from day_reports where staff_id='$user_id' and (cast(trans_date as date) BETWEEN '$s' AND
//'$e')";

        $query = "select * from day_reports where staff_id='$user_id' and trans_date >= '$s' and trans_date <= '$e'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->balance = $row['balance'];
            $obj->trans_date = $row['trans_date'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    //cash acc rp
    public function cash_reportsx($s, $e) {
        $query = "select * from cash_report where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    //cash acc rp
    public function cash_reportsx_proved($s, $e) {
        $query = "select * from cash_report where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    //cash acc rp
    public function cash_bf($s, $e) {
        $query = "select * from cash_report where date_cr >= '$s' and date_cr <= '$e' order by date_cr desc limit 1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function vt_bf($s, $e) {
        $query = "select * from vault_report where date_cr >= '$s' and date_cr <= '$e' order by id desc limit 1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function opening_bal($e, $s, $check_month) {
        $query = "select * from cash_report where date_cr<'$s' order by id desc limit 1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function opening_balsc($s) {
        $query = "select * from cash_report where date_cr<'$s' order by date_cr desc limit 1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function opening_bank_statement($s, $rtype) {
        $query = "select * from bank_statement where posted_dated<'$s' and bank_id=$rtype and auto_transaction='1' order by id desc limit 1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function opening_vault_report($s) {
        $query = "select * from vault_report where date_cr <'$s' order by id desc limit 1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function auto_vault_report() {
        $query = "select * from vault_report where auto_transaction='0'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $obj->decode = $row['decode'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    //cash acc rp
    public function banks_reportsx($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' order  by date_cr asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->balance = $row['balance'];
            $obj->date_cr = $row['date_cr'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    // teacher list in school
    public function bank_infos($get_user_id) {
        $query = "SELECT * FROM banks where id='$get_user_id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->bank_name = $row['bank_name'];
        $obj->bal = $row['bal'];
        $user_list[] = $obj;
        return $obj;
    }

    //All user info sorted by id
    public function get_expenses($id) {
        $query = "select * from expenses where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->expenese_name = $row['expenese_name'];

        return $obj;
    }

    //bank auto
    public function banks_autos() {
        $query = "select * from bank_statement where  auto_transaction='0' and trans_types!='6' and inter_bank_status='0' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->bank_id = $row['bank_id'];
            $obj->trans_types = $row['trans_types'];
            $obj->balance = $row['balance'];
            $obj->dcode = $row['dcode'];
            $obj->bank_id = $row['bank_id'];

            $bank_info = $this->bank_infos($row['bank_id']);
            $obj->bank_name = $bank_info->bank_name;

            $bank_info = $this->get_expenses($row['trans_types']);
            $obj->expenese_name = $bank_info->expenese_name;

            $user_list[] = $obj;
        }
        return $user_list;
    }

    //bank auto
    //bank auto
    public function banks_autose() {
        $query = "select * from bank_statement where  auto_transaction='0' and inter_bank_status='1' and cr='0' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->bank_id = $row['bank_id'];
            $obj->trans_types = $row['trans_types'];
            $obj->balance = $row['balance'];
            $obj->dcode = $row['dcode'];
            $obj->from_bank = $row['from_bank'];
            $obj->to_bank = $row['to_bank'];
            $user_list[] = $obj;

            $bank_info = $this->bank_infos($row['from_bank']);
            $obj->bank_name = $bank_info->bank_name;

            $bank_to = $this->bank_infos($row['to_bank']);
            $obj->bank_name_to = $bank_to->bank_name;

        }
        return $user_list;
    }


    public function cash_autos() {
        $query = "select * from cash_report where  auto_transaction='0' and approved_by='cash' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->trans_types = $row['trans_types'];
            $obj->balance = $row['balance'];
            $obj->dcode = $row['dcode'];

            $hod_info = $this->info_by_dcode_expenses($row['dcode']);
            $obj->type = $hod_info->type;

            $user_list[] = $obj;
        }
        return $user_list;
    }

    //All user info sorted by id
    public function info_by_dcode_expenses($id) {
        $query = "select * from expenses_data where dcode='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->date_added = $row['date_added'];
        $obj->description = $row['description'];
        $obj->amount = $row['amount'];
        $obj->type = $row['type'];



        return $obj;
    }

    public function suspense_autos() {
        $query = "select * from despense_account_history where  auto_transaction='0' and approved_by='suspense' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['cr_date'];
            $obj->trans_types = $row['trans_types'];
            $obj->balance = $row['balance'];
            $obj->dcode = $row['dcode'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    //cash acc rp
    public function banks_report_rc($rtype, $s, $e) {
        $query = "select * from bank_statement where posted_dated >= '$s' and posted_dated <= '$e' and bank_id='$rtype' and auto_transaction='1' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $obj->posted_dated = $row['posted_dated'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function banks_proved($s, $e) {
        $query = "select * from bank_statement where date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' and bank_id not in(20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36) order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    //suspense acc rp
    public function despense_account_history($s, $e) {
        $query = "select * from despense_account_history where cr_date >= '$s' and cr_date <= '$e' and auto_transaction='1'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->balance = $row['balance'];
            $obj->cr_date = $row['cr_date'];
            $user_list[] = $obj;
        }
        return $user_list;
    }  //suspense acc rp

    public function despense_account_history_proved($s, $e) {
        $query = "select * from despense_account_history where cr_date >= '$s' and cr_date <= '$e' and auto_transaction='1'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->balance = $row['balance'];
            $obj->cr_date = $row['cr_date'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    public function delete_staff_n($uid) {
        $query = "update staffs_accounts set status='0' where id='$uid'";
        return $this->runner($query);
    }


    public function ec($ec) {
        $query = "update loans set status_new='1' where id='$ec'";
        return $this->runner($query);
    }


    public function bd_deths($sid) {
        $query = "update loans set bad_debt='1' where customer_id='$sid'";
        return $this->runner($query);
    }


    public function update_exxx($dc, $cat, $amount, $cid) {
        $query = "update expenses_data set description='$dc', amount='$amount', type='$cat' where id='$cid'";
        return $this->runner($query);
    }

    public function mode_banks($id, $balance) {
        $query = "update bank_statement set balance='$balance' where id='$id'";
        return $this->runner($query);
    }


    public function opening_bank_statement_close($rtype) {
        $query = "select * from bank_statement where bank_id=$rtype and auto_transaction='1' order by id limit 1";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }



    //    public function mode_banks_cash_acc($id,$datec,$dr,$cr,$cv,$balance,$description)
//    {
//          $query ="update cash_report set balance='$cv' where id='$id'";
//        return $this->runner($query);
// }
    public function mode_banks_cash_acc($id, $datec, $dr, $cr, $balance, $description) {
        $query = "update cash_report set dr='$dr', cr='$cr',balance='$balance',description='$description' where id='$id'";
        return $this->runner($query);
    }

    // public function update_customer_loans($customer_id, $loan_amount, $paid_principal,$bal)
    // {
    //     $query = "update customer set total_loan='$loan_amount', loan_paid='$paid_principal',balance='$bal', loan_type='$loan_type' where id='$customer_id'";
    //     return $this->runner($query);
    // }



    public function update_customer_loans($customer_id, $new_loan_amt, $paid_principal, $bal, $loan_type,$rev) {
        $query = "update customer set total_loan='$new_loan_amt', loan_paid='$paid_principal',balance='$bal',revs='$rev', loan_type='$loan_type' where id='$customer_id'";
        return $this->runner($query);
    }

    public function mode_vot($id, $cv) {
        $query = "update despense_account_history set balance='$cv' where id='$id'";
        return $this->runner($query);
    }

    public function mode_vot1($id, $cv) {
        $query = "update vault_report set balance='$cv' where id='$id'";
        return $this->runner($query);
    }

    public function deles($id) {
        $query1 = "delete from customer_rp where cus_id='$id'";
        return $this->runner($query1);

    }

    // public function mode_banks_cash_accc($id, $loan_date, $loan_amount)
    // {
    //     $query = "INSERT INTO `customer_rp` (`id`, `cus_id`, `dr`, `cr_date`) VALUES (NULL, '$id', '$loan_amount', '$loan_date')";
    //     return $this->runner($query);
    // }


    public function mode_banks_cash_accc($id, $loan_date, $loan_amount, $description) {
        $query = "INSERT INTO `customer_rp` (`id`, `cus_id`, `dr`, `cr_date`,`description`) VALUES (NULL, '$id', '$loan_amount', '$loan_date','$description')";
        return $this->runner($query);
    }

    // public function mode_banks_cash_acccx($id, $loan_date, $loan_amount)
    // {
    //     $query = "INSERT INTO `customer_rp` (`id`, `cus_id`, `cr`, `cr_date`) VALUES (NULL, '$id', '$loan_amount', '$loan_date')";
    //     return $this->runner($query);
    // }


    public function mode_banks_cash_acccx($id, $loan_date, $loan_amount, $description, $interest) {
        $query = "INSERT INTO `customer_rp` (`id`, `cus_id`, `cr`, `cr_date`,`description`,`interest`) VALUES (NULL, '$id', '$loan_amount', '$loan_date','$description','$interest')";
        return $this->runner($query);
    }

    
    public function mode_banks_cash_rev($id, $loan_date, $loan_amount, $description, $interest) {
        $query = "INSERT INTO `customer_rp` (`id`, `cus_id`, `dr`, `cr_date`,`description`,`interest`) VALUES (NULL, '$id', '$loan_amount', '$loan_date','$description','$interest')";
        return $this->runner($query);
    }



    public function mode_banks_suspense($id, $datec, $dr, $cr, $balance, $description) {
        $query = "update despense_account_history set balance='$balance' where id='$id'";
        return $this->runner($query);
    }


    public function delete_loan_n($uid) {
        $query = "update loans set status='1' where id='$uid'";
        return $this->runner($query);
    }

    public function close_loansed($customer_id) {
        $query = "update customer set outstanding='1' where id='$customer_id'";
        return $this->runner($query);
    }

    public function close_loansedxxxx($customer_id,$new_loan_amt) {
         $query = "update customer set total_loan='$new_loan_amt' where id='$customer_id'";
        return $this->runner($query);
    }


    public function extra_loads() {

        $query = "SELECT * FROM customer where balance!=0 and loan_type='Interest Free'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->c_name = $row['c_name'];
            $obj->total_loan = $row['total_loan'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->loan_paid = $row['loan_paid'];
            $obj->outstanding = $row['outstanding'];
            $obj->balance = $row['balance'];

            $user_list[] = $obj;
        }
        return $user_list;
    }



    public function extra_loads_free() {

        $query = "SELECT * FROM customer where balance!=0 and loan_type='Interest Free'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->c_name = $row['c_name'];
            $obj->total_loan = $row['total_loan'];
            $obj->loan_amount = $row['loan_amount'];
            $obj->loan_paid = $row['loan_paid'];
            $obj->outstanding = $row['outstanding'];
            $obj->balance = $row['balance'];

            $user_list[] = $obj;
        }
        return $user_list;
    }




    public function update_loans_cus($cus_bankid, $bankid, $surety_address, $surety_dpt, $surety_phone, $surety_name, $rate, $loan_type, $due_date, $amount, $loan_date, $client) {
        $query = "update loans set bank_id='$bankid',cus_bankid='$cus_bankid', loan_date='$loan_date',loan_amount='$amount',Due_date='$due_date',loan_type='$loan_type',rate='$rate',surety_name='$surety_name',surety_work_address='$surety_address',surety_phone='$surety_phone',surety_dpt='$surety_dpt' where id='$client'";
        return $this->runner($query);
    }

    public function delete_loanpans($uid) {
        $query = "update repayment set status='1' where id='$uid'";
        return $this->runner($query);
    }


    public function update_repayment_ins($uid) {
        $query = "update repayment set loan_types='0' where customer_id='$uid'";
        return $this->runner($query);
    }


    public function ban_staffs($uid) {
        $query = "update staffs_accounts set ban='1' where id='$uid'";
        return $this->runner($query);
    }

    public function delete_customers($uid) {
        $query = "update customer set status='0' where id='$uid'";
        return $this->runner($query);
    }

    public function delete_wc($uid) {
        $query = "update work_center set status='1' where id='$uid'";
        return $this->runner($query);
    }

    public function delete_expense_cxat($uid) {
        $query = "update expenses set status='1' where id='$uid'";
        return $this->runner($query);
    }


    public function delete_expense_cxats($uid) {
        $query = "delete from expenses where id='$uid'";
        return $this->runner($query);
    }

    public function expenses_data($uid) {
        $query = "delete from expenses_data where dcode='$uid'";
        return $this->runner($query);
    }

    public function re_suspense($dcode, $description, $cr, $suspense, $types, $ty) {
        $theDate = new DateTime('Y-m-d H:i:s');
        $get_date = $theDate->format('Y-m-d H:i:s');

        $query = "INSERT INTO `expenses_data` (`id`, `date_added`, `description`, `type`, `account`, `status`,`cr`,`balance`,`by_user`,`dcode`,`types`,`bank_id`,`rev`) VALUES (NULL, '$get_date', '$description', '$ty', '0', '0', '$cr','$suspense','0','$dcode','2','0','1')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function rev_cash($dcode, $description, $cr, $v, $types, $ty) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `expenses_data` (`id`, `date_added`, `description`, `type`, `account`, `status`,`cr`,`balance`,`by_user`,`dcode`,`types`,`bank_id`,`rev`) VALUES (NULL, '$get_date', '$description', '$ty', '0', '0', '$cr','$v','0','$dcode','1','0','1')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function rev_bank($dcode, $description, $cr, $cv, $types, $ty, $banks_id) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `expenses_data` (`id`, `date_added`, `description`, `type`, `account`, `status`,`cr`,`balance`,`by_user`,`dcode`,`types`,`bank_id`,`rev`) VALUES (NULL, '$get_date', '$description', '$ty', '0', '0', '$cr','$cv','0','$dcode','0','$banks_id','1')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function re_suspense_cash($dcode, $description, $cr, $v, $types, $ty) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `expenses_data` (`id`, `date_added`, `description`, `type`, `account`, `status`,`cr`,`balance`,`by_user`,`dcode`,`types`,`bank_id`,`rev`) VALUES (NULL, '$get_date', '$description', '$ty', '0', '0', '$cr','$v','0','$dcode','0','0','1')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function re_suspense_history($dcode, $description, $cr, $suspense, $types, $ty) {
        $theDate = new DateTime('Y-m-d H:i:s');
        $get_date = $theDate->format('Y-m-d H:i:s');

        $query = "INSERT INTO `despense_account_history` (`id`, `description`, `cr`, `dr`, `balance`, `cr_date`, `dcode`) VALUES (NULL, '$description', '', '$cr', '$suspense','$get_date','$dcode')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function expenses_data_rs($dcode) {
        $query = "update expenses_data set rev='1' where dcode='$dcode'";
        return $this->runner($query);
    }


    public function despenses_data_rs($dcode, $description) {
        $query = "update despense_account_history set rev='1' where dcode='$dcode'";
        return $this->runner($query);
    }

    public function cash_report_rv($dcode) {
        $query = "update cash_report set rev='1' where dcode='$dcode'";
        return $this->runner($query);
    }

    public function bank_report_rv($dcode) {
        $query = "update bank_statement set rev='1' where dcode='$dcode'";
        return $this->runner($query);
    }


    public function delete_suspensec($uid) {
        $query = "delete from despense_account_history where dcode='$uid'";
        return $this->runner($query);
    }

    public function delete_day_rp($uid) {
        $query = "delete from day_reports where dcode='$uid'";
        return $this->runner($query);
    }

    public function del_from_cash_account($uid) {
        $query = "delete from cash_report where dcode='$uid'";
        return $this->runner($query);
    }

    public function del_from_bank_statement($uid) {
        $query = "delete from bank_statement where dcode='$uid'";
        return $this->runner($query);
    }

    public function addfund_cash($v) {
        $query = "update cash_account set balance='$v' where id='1'";
        return $this->runner($query);
    }

    public function addfund_cash_vt($v) {
        $query = "update vault set balance='$v' where id='1'";
        return $this->runner($query);
    }

    public function approveds_volt($volt, $decode) {
        $query = "update vault set balance='$volt' where id='1'";
        return $this->runner($query);
    }

    public function approveds_volt_history($volt, $decode) {
        $query1 = "update vault_report set balance='$volt',auto_transaction='1' where decode='$decode'";
        return $this->runner($query1);
    }

    public function approveds_cash_history($new_cash, $decode) {
        $query1 = "update cash_report set balance='$new_cash',auto_transaction='1' where dcode='$decode'";
        return $this->runner($query1);
    }

    public function despense_history_approved($new_suspense, $decode) {
        $query1 = "update despense_account_history set balance='$new_suspense',auto_transaction='1' where dcode='$decode'";
        return $this->runner($query1);
    }

    public function expenses_data_approved($bank_balance, $decode) {
        $query1 = "update expenses_data set balance='$bank_balance',auto_transaction='1' where dcode='$decode'";
        return $this->runner($query1);
    }

    public function staff_report($bank_balance, $decode) {
        $query1 = "update day_reports set auto_transaction='1',balance='$bank_balance' where dcode='$decode'";
        return $this->runner($query1);
    }

    public function day_report_approved($decode) {
        $query1 = "update day_reports set auto_transaction='1' where dcode='$decode'";
        return $this->runner($query1);
    }

    public function add_funds_suspense($v) {
        $query = "update despense_account set balance='$v' where id='1'";
        return $this->runner($query);
    }


    public function debit_cash_account($cv) {
        $query = "update cash_account set balance='$cv' where id='1'";
        return $this->runner($query);
    }

    public function dr_banks($bank_balance, $banks_id) {
        $query = "update banks set bal='$bank_balance' where id='$banks_id'";
        return $this->runner($query);
    }

    public function approved_banks($bank_balance, $banks_id) {
        $query1 = "update banks set bal='$bank_balance' where id='$banks_id'";
        return $this->runner($query1);
    }

    public function approved_banks_repay($nbal, $bank, $decode) {
        $query = "update bank_statement set balance='$nbal',auto_transaction='1' where dcode='$decode' and bank_id='$bank'";
        return $this->runner($query);
    }

    public function approved_banks_statement($bank_balance, $banks_id, $decode) {
        $query = "update bank_statement set balance='$bank_balance',auto_transaction='1' where dcode='$decode' and bank_id='$banks_id'";
        return $this->runner($query);
    }
    public function approved_banks_statement_to($decode) {
        $query = "update bank_statement set auto_transaction='1' where dcode='$decode'";
        return $this->runner($query);
    }

    public function dr_cashvt($cv) {
        $query = "update vault set balance='$cv' where id='1'";
        return $this->runner($query);
    }

    public function rep_approval($decode) {
        $query = "update repayment set auto_transaction='1' where dcode='$decode'";
        return $this->runner($query);
    }

    // public function decline_repayments($decode)
    // {
    //     $query = "update repayment set interest_paid='unpaid',principal_paid='unpaid' where decode='$decode'";
    //     return $this->runner($query);
    // }

    public function decline_repayments($decode) {
        $query = "delete from repayment where dcode='$decode'";
        return $this->runner($query);
    }

    public function decline_cashouts($decode) {
        $query = "delete from cash_report where dcode='$decode'";
        return $this->runner($query);
    }

    public function decline_cashouts_day_report($decode) {
        $query = "delete from day_reports where dcode='$decode'";
        return $this->runner($query);
    }

    public function dr_suspense($cv) {
        $query = "update despense_account set balance='$cv' where id='1'";
        return $this->runner($query);
    }

    public function new_acc_bal($v, $acc) {
        $query = "update despense_account set balance='$v' where id='$acc'";
        return $this->runner($query);
    }


    public function add_rc($cr, $bal, $acc, $v) {
        $query = "INSERT INTO `despense_account_history` (`id`, `description`, `depense_id`, `cr`, `dr`, `balance`,`cancel_transaction`) VALUES (NULL, 'Cancelled Transaction', '$acc', '0', '$cr', '$v', 'yes');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function delete_bank($uid) {
        $query = "update banks set status='1' where id='$uid'";
        return $this->runner($query);
    }


    //delete bank pending transaction
    public function approved_bank_del($decode, $bid) {
        $query = "delete from bank_statement where id='$bid'";
        return $this->runner($query);
    }


    //delete bank pending transaction
    public function approved_bank_del_to($decode) {
        $query = "delete from bank_statement where dcode='$decode'";
        return $this->runner($query);
    }

    public function approved_bank_del_despense($decode, $bid) {
        $query = "delete from despense_account_history where dcode='$decode'";
        return $this->runner($query);
    }

    public function approved_bank_del_expenses_data($decode, $bid) {
        $query2 = "delete from expenses_data where dcode='$decode'";
        return $this->runner($query2);
    }

    public function approved_bank_del_cash_report($decode, $bid) {
        $query3 = "delete from cash_report where dcode='$decode'";
        return $this->runner($query3);
    }

    public function approved_bank_del_vault_report($decode, $bid) {
        $query4 = "delete from vault_report where decode='$decode'";
        return $this->runner($query4);
    }


    public function delete_bank_statement($uid) {
        $query = "delete from bank_statement where id='$uid'";
        return $this->runner($query);
    }

    public function delete_depenses($uid) {
        $query = "update despense_account set status='1' where id='$uid'";
        return $this->runner($query);
    }

    public function delete_trial_balance_cats($uid) {
        $query = "update trial_balance_cats set status='1' where id='$uid'";
        return $this->runner($query);
    }

    public function delete_dptsx($uid) {
        $query = "update department set status='1' where id='$uid'";
        return $this->runner($query);
    }

    public function delete_interests($uid) {
        $query = "update interest set status='1' where id='$uid'";
        return $this->runner($query);
    }

    public function change_work_center($wc, $work_center, $cus_id) {
        $query = "update work_center set center_name='$wc',center_code='$work_center' where id='$cus_id'";
        return $this->runner($query);
    }

    public function change_info($wc, $cus_id, $status) {
        $query = "update expenses set expenese_name='$wc',status='$status' where id='$cus_id'";
        return $this->runner($query);
    }

    public function update_banks($bn, $acn, $bads, $cus_id, $bals) {
        $query = "update banks set bank_name='$bn',account_no='$acn', bank_address='$bads',bal='$bals'  where id='$cus_id'";
        return $this->runner($query);
    }

    public function update_dpts($cats, $cus_id) {
        $query = "update department set dpt='$cats' where id='$cus_id'";
        return $this->runner($query);
    }

    //=======================================
    public function update_pay_principal($uid) {
        $get_date = date('Y-m-d H:i:s');
        $query = "update repayment set principal_paid='paid', interest_paid='paid' where id='$uid'";
        return $this->runner($query);
    }

    //=======================================
    public function update__principal($uid) {
        $get_date = date('Y-m-d H:i:s');
        $query = "update repayment set principal_paid='paid', principal_paid_date='$get_date' where id='$uid'";
        return $this->runner($query);
    }

    public function update_pay_ie($uid) {
        $query = "update repayment set interest_paid='paid' where id='$uid'";
        return $this->runner($query);
    }

    public function x_interest($uid) {
        $query = "update repayment set interest_paid='unpaid', interest_paid_date='' where id='$uid'";
        return $this->runner($query);
    }

    // public function x_principal($uid)
    // {
    //     $query = "update repayment set principal_paid='unpaid', principal_paid_date='',interest_paid='unpaid',interest_paid_date='' where id='$uid'";
    //     return $this->runner($query);
    // }

    public function x_principal($dcode) {
        $query = "delete from repayment  where dcode='$dcode'";
        return $this->runner($query);
    }

    public function update_pay_interest($uid) {
        $get_date = date('Y-m-d H:i:s');
        $query = "update repayment set interest_paid='paid', interest_paid_date='$get_date' where id='$uid'";
        return $this->runner($query);
    }


    public function update_pay_laons($uid) {
        $get_date = date('Y-m-d H:i:s');
        $query = "update repayment set principal_paid='paid', principal_paid_date='$get_date' where id='$uid'";
        return $this->runner($query);
    }

    // public function update_loanrepayments($loan_id, $principal, $interest, $due_date, $camount, $cus_bankid,$posted_date)
    // {
    //     $query = "update repayment set principal='$principal',interest='$interest', due_date='$due_date',cheque_amount='$camount',bank_id='$cus_bankid',interest_paid_date='$posted_date', principal_paid_date='$posted_date', posted_dated='$posted_date' where id='$loan_id'";
    //     return $this->runner($query);
    // }


    public function update_loanrepayments($loan_id, $principal, $interest, $due_date, $camount, $cus_bankid, $posted_date, $description) {
        $query = "update repayment set principal='$principal',interest='$interest',cheque_amount='$camount',bank_id='$cus_bankid',interest_paid_date='$due_date', principal_paid_date='$due_date', posted_dated='$posted_date',description='$description' where id='$loan_id'";
        return $this->runner($query);
    }

    //reversal for loan repayment
    public function rev_repayment($loan_id, $principal, $interest, $due_date, $camount, $cus_bankid, $posted_date, $description,$customer_id) {
        $query = "INSERT INTO `repayment` (`id`,`customer_id`,`principal`,`interest`,`due_date`,`interest_paid`, `principal_paid`,`interest_paid_date`,`principal_paid_date`,`loan_id`,`entered_by`, `status`, `bank_id`, `method_pay`, `cheque_amount`, `dcode`, `auto_transaction`, `approved_by`, `loan_types`, `posted_dated`, `description`, `rev_status`) VALUES (NULL, '$customer_id', '$principal', '$interest', '$due_date', 'paid', 'paid', '$due_date', '$due_date', '$loan_id', NULL, '0', '$cus_bankid', NULL, '$camount', NULL, '1', '', '1', '$posted_date', '$description', '1')";
        return $this->runner($query);
    }

    //reversal for loan repayment to bank
    public function rev_repayment_banks($loan_id, $principal, $interest, $due_date, $camount, $cus_bankid, $posted_date, $description,$customer_id) {
        $query = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `posted_dated`, `bank_id`, `cus_id`, `description`, `balance`, `dcode`, `rev`, `test`, `trans_types`, `auto_transaction`, `approved_by`, `inter_bank_status`, `from_bank`, `to_bank`, `endofday`) VALUES (NULL, '$loan_id', '0', '$principal', NULL, '$due_date', '$posted_date', '$cus_bankid', '$customer_id', '$description', '0', NULL, '', '0', '', '1', '', '', '', '', '0')";
        return $this->runner($query);
    }


    public function update_loans($cats, $cus_id) {
        $query = "update interest set loans='$cats' where id='$cus_id'";
        return $this->runner($query);
    }

    public function update_acount_ifo($cats, $dsc, $cus_id) {
        $query = "update trial_balance_cats set cats='$cats',description='$dsc' where id='$cus_id'";
        return $this->runner($query);
    }

    public function update_staffss($fullname, $position, $department, $email, $address, $phone, $gender, $staff_id, $pwd) {
        $query = "update staffs_accounts set fullname='$fullname',postion='$position', department='$department',email='$email', address='$address', phone='$phone', gender='$gender',ban='0',password='$pwd' where id='$staff_id'";
        return $this->runner($query);
    }

    public function update_cus_info($tittle, $c_name, $sex, $work_center, $dpt, $work_address, $home_address, $cphone, $cemail, $cus_id) {
        $query = "UPDATE `customer` SET `tittle`='$tittle',`c_name`='$c_name',`sex`='$sex',`work_center`='$work_center',`dpt`='$dpt',`work_address`='$work_address',`home_address`='$home_address',`cphone`='$cphone',`cemail`='$cemail' WHERE id='$cus_id'";
        return $this->runner($query);
    }


    //count number of client in hospital
    public function count_staffs() {
        $query = "select * from staffs_accounts";
        $run_query = $this->run_query($query);
        return $this->get_number_of_row($run_query);
    }

    //count number of client in hospital
    public function sus_pending() {
        $query = "select * from despense_account_history where auto_transaction=0";
        $run_query = $this->run_query($query);
        return $this->get_number_of_row($run_query);
    }

    public function cash_pending() {
        $query = "select * from cash_report where auto_transaction=0";
        $run_query = $this->run_query($query);
        return $this->get_number_of_row($run_query);
    }

    public function count_debt() {
        $query = "select * from loans where bad_debt='1'";
        $run_query = $this->run_query($query);
        return $this->get_number_of_row($run_query);
    }

    public function banks_pending() {
        $query = "select * from bank_statement where auto_transaction=0";
        $run_query = $this->run_query($query);
        return $this->get_number_of_row($run_query);
    }

    //count number of client in hospital active
    public function customer() {
        $query = "select * from customer";
        $run_query = $this->run_query($query);
        return $this->get_number_of_row($run_query);
    }


    public function get_valuts() {
        $query = "select * from vault where id='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->balance = $row['balance'];
        $obj->cr = $row['cr'];
        $obj->dr = $row['dr'];

        return $obj;
    }

    public function get_sus() {
        $query = "select * from despense_account where id='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->balance = $row['balance'];


        return $obj;
    }

    public function get_cahs_acc() {
        $query = "select * from cash_account where id='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->balance = $row['balance'];
        $obj->cr = $row['cr'];
        $obj->dr = $row['dr'];

        return $obj;
    }


    //All user info sorted by id
    public function get_user_info($id) {
        $query = "select * from staffs_accounts where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->user_id = $row['id'];
        $obj->email = $row['email'];
        $obj->fullname = $row['fullname'];
        return $obj;
    }


    public function get_staffs_info($id) {
        $query = "select * from staffs where id='$id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->id = $row['id'];
        $obj->fn = $row['fn'];
        $obj->ln = $row['ln'];

        return $obj;
    }





    public function de_statement($uid, $status) {
        if($status == 'i') {
            $query = "delete from bank_statement where loan_id='$uid' and repay_id='i'";
        } elseif($status == 'p') {
            $query = "delete from bank_statement where loan_id='$uid' and repay_id='p'";
        } elseif($status == 'c') {
            $query = "delete from bank_statement where loan_id='$uid'";
        }
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    // public function de_s($uid, $status)
    // {
    //     $query = "delete from bank_statement where loan_id='$uid'";
    //     $run_qry = $this->run_query($query);
    //     if ($run_qry == true) {
    //         return "success";
    //     } else {
    //         return "Invalid Command";
    //     }
    // }

    public function de_s($dcode, $status) {
        $query = "delete from bank_statement where dcode='$dcode' and repay_id='c'";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function decline_repayment_from_banks($decode) {
        $query = "delete from bank_statement where dcode='$decode' and repay_id='c'";
        return $this->runner($query);
    }


    // public function bank_statement_rp($uid, $loan_id, $amount, $cus, $bank, $status, $nbal, $bank_name, $avlc_name, $dcode,$posted)
    // {
    //     $get_date = date('Y-m-d H:i:s');
    //     $query = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`,`balance`,`description`,`dcode`) VALUES (NULL,'$uid','$status','0','$amount','$get_date','$bank','$cus','$nbal','Loan Repayment from $avlc_name','$dcode')";
    //     $run_qry = $this->run_query($query);
    //     if ($run_qry == true) {
    //         return "success";
    //     } else {
    //         return "Invalid Command";
    //     }
    // }

    //   public function bank_statement_rp($uid, $loan_id, $amount, $cus, $bank, $status, $nbal, $bank_name, $avlc_name, $dcode,$posted,$description)
//     {
//         $get_date = date('Y-m-d H:i:s');
//         $query = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`,`balance`,`description`,`dcode`,`posted_dated`,`auto_transaction`) VALUES (NULL,'$uid','$status','0','$amount','$posted','$bank','$cus','$nbal','$description / $avlc_name','$dcode','$posted','0')";
//         $run_qry = $this->run_query($query);
//         if ($run_qry == true) {
//             return "success";
//         } else {
//             return "Invalid Command";
//         }
//     }

    public function bank_statement_rp($uid, $loan_id, $amount, $cus, $bank, $status, $nbal, $bank_name, $avlc_name, $dcode, $posted, $description, $value_date) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`,`balance`,`description`,`dcode`,`posted_dated`,`auto_transaction`) VALUES (NULL,'$uid','$status','0','$amount','$value_date','$bank','$cus','$nbal','$description / $avlc_name','$dcode','$posted','0')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function bank_state($amount, $banks_id, $status, $cv, $banks_name, $description, $decode, $acc_types, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`,`balance`,`description`,`trans_types`,`auto_transaction`,`dcode`,`approved_by`) VALUES (NULL,'0','$status','$amount','0','$posted','$banks_id','0','$cv','$description / from $banks_name','$acc_types','0','$decode','bank')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //vault Reports
    public function vault_history($amount, $v, $banks_name, $description, $decode, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `vault_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`, `trans_types`, `auto_transaction`, `decode`, `approved_by`) VALUES (NULL, '$description / From $banks_name', NULL, '$amount', NULL, '$get_date', '$v','5','0','$decode','bank')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }


    //vault Reports
    public function vault_history_refunds($amount, $vot_bal, $bank_names, $de, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `vault_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`) VALUES (NULL, '$de / Transferred to  $bank_names', 'NULL', '0', '$amount', '$get_date', '$vot_bal')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }


    //vault Reports vault to cash-vot
    public function cash_to_vot($amount, $cv, $de, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `vault_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`) VALUES (NULL, '$de', NULL, '$amount', '0', '$get_date', '$cv')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }


    //vault Reports vault to cash
    public function vault_historyx($amount, $cv, $de, $decode, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `vault_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`, `auto_transaction`, `decode`) VALUES (NULL, '$de', NULL, '0', '$amount', '$get_date', '$cv',auto_transaction='0','$decode')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash
    public function cashreports($amount, $v, $de, $decode, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `cash_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`, `auto_transaction`, `dcode`) VALUES (NULL, '$de ', NULL, '$amount', '0', '$get_date', '$v','0','$decode')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }


    //cash Reports vault to cash
    public function bank_cash_rp($amount, $v, $banks_name, $description, $decode) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `cash_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`, `trans_types`, `auto_transaction`,`dcode`,`approved_by`) VALUES (NULL, '$description / from $banks_name', NULL, '$amount', '0', '$get_date', '$v','2','0','$decode','bank')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash
    public function rev_cash_report($dcode, $description, $cr, $cv, $types, $ty) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `cash_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`) VALUES (NULL, '$description', NULL, '$cr', '0', '$get_date', '$cv')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash
    public function rev_bank_report($dcode, $description, $cr, $cv, $types, $ty, $banks_id) {
        $get_date = date('Y-m-d H:i:s');
        $cdate = date("Y-m-d H:i:s", strtotime($get_date));
        //to
        $query1 = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`, `description`, `balance`, `dcode`) VALUES (NULL, NULL, NULL, '0', '$cr', '$cdate', '$banks_id', NULL, '$description','$cv', '$dcode');";
        $run_qry = $this->run_query($query1);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }


    //cash Reports vault to cash
    public function cashreportscc($amount, $cash_bal, $bank_names, $de) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `cash_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`) VALUES (NULL, '$de / Cash acc to $bank_names', NULL, '0', '$amount', '$get_date', '$cash_bal')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash
    public function suspense_cash($amount, $v) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `cash_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`) VALUES (NULL, 'Transferred from Suspense Account to Cash Account ', NULL, '$amount', '0', '$get_date', '$v')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash dr
    public function cash_vot_rp($amount, $cv, $de, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `cash_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`) VALUES (NULL, '$de', NULL, '0', '$amount', '$get_date', '$cv')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash dr
    public function cashreportdrs($amount, $cv, $de, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `cash_report` (`id`, `description`, `transaction_id`, `dr`, `cr`, `date_cr`, `balance`) VALUES (NULL, '$de', NULL, '0', '$amount', '$get_date', '$cv')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash dr
    public function dr_suspenesesx($amount, $suspense_bal, $bank_names, $de, $vot_balh, $tdates) {
        $get_date = $tdates;
        $query = "INSERT INTO `despense_account_history` (`id`, `description`, `cr`, `dr`, `balance`, `cr_date`) VALUES (NULL, '$de', '$amount', '0', '$vot_balh','$tdates')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash dr
    public function suspense_to_customer($amount, $suspense_bal, $bank_names, $de, $vot_balh, $tdate, $decode) {
        $get_date = $tdate;
        $query = "INSERT INTO `despense_account_history` (`id`, `description`, `cr`, `dr`, `balance`, `cr_date`, `dcode`) VALUES (NULL, '$de', '$amount', '0', '$vot_balh', '$get_date','$decode')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash dr
    public function refund_to_customer($amount, $bank_bal, $de, $tdate, $decode, $cus_id, $bank_id) {
        $get_date = $tdate;
        $query1 = "INSERT INTO `customer_account` (`id`, `customer_id`, `cr`, `dr`, `created_date`, `descriptions`, `bal`, `dcode`) VALUES (NULL, '$cus_id', NULL, '$amount', '$tdate', '$de', '$bank_bal', '$decode')";
        $run_qry1 = $this->run_query($query1);
        if($run_qry1 == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash dr
    public function refund_to_customers_banks($amount, $bank_bal, $de, $tdate, $decode, $cus_id, $bank_id) {
        $get_date = $tdate;
        $query = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`, `description`, `balance`, `dcode`, `rev`) VALUES (NULL, '0', '0', '$amount', NULL, '$tdate', '$bank_id', '$cus_id', '$de', '$bank_bal', '$decode', '0')";
        $run_qry = $this->run_query($query);
        if($query == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash dr
    public function bank_suspense($amount, $v, $banks_name, $description, $decode, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `despense_account_history` (`id`, `description`, `cr`, `dr`, `balance`, `cr_date`, `dcode`,`auto_transaction`,`approved_by`) VALUES (NULL, '$description', '0', '$amount', '$v', '$get_date','$decode','0','bank')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function funds_to_customer($amount, $suspense_bal, $cus_id, $bank_names, $de, $vot_balh, $tdate, $decode) {
        $get_date = $tdate;
        $query = "INSERT INTO `customer_account` (`id`, `customer_id`, `cr`, `dr`, `created_date`, `descriptions`, `bal`, `dcode`) VALUES (NULL, '$cus_id', '0', '$amount', '$get_date', '$de', '$suspense_bal','$decode');";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function add_history_suspenses($amount, $new_account, $dc, $cdate, $cat, $user_id) {
        $dcode = rand(1234567, 1234567890);
        $get_date = date('Y-m-d H:i:s');
        //suspense history
        $query = "INSERT INTO `despense_account_history` (`id`, `description`, `cr`, `dr`, `balance`, `cr_date`, `dcode`, `approved_by`, `auto_transaction`) VALUES (NULL, '$dc', '$amount', '0', '$new_account','$cdate','$dcode','suspense','0')";

        //expenses history
        $query1 = "INSERT INTO `expenses_data` (`id`, `date_added`, `description`, `type`, `account`, `status`, `dr`, `balance`, `dcode`, `types`, `approved_by`, `auto_transaction`) VALUES (NULL, '$cdate', '$dc', '$cat', '0', '0', '$amount','$new_account','$dcode','2','suspense','0');";


        //cash day report
        $query3 = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `balance`, `trans_date`, `status`, `dcode`) VALUES (NULL, '$dc from expenses acc', '$user_id', '$amount', NULL, '$new_account', '$get_date', NULL, '$dcode');";
        //day expenses reports
        $query4 = "INSERT INTO `day_reports` (`id`, `description`, `staff_id`, `dr`, `cr`, `balance`, `trans_date`, `status`, `dcode`) VALUES (NULL, '$dc to expenses acc', '$user_id', '0', $amount, '$new_account', '$get_date', NULL, '$dcode');";


        $run_qry = $this->run_query($query);
        $run_qry1 = $this->run_query($query1);
        $run_qry3 = $this->run_query($query3);
        $run_qry4 = $this->run_query($query4);

        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //cash Reports vault to cash dr
    public function dr_suspenese($amount, $v, $de, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `despense_account_history` (`id`, `description`, `cr`, `dr`, `balance`, `cr_date`) VALUES (NULL, '$de', NULL, '$amount', '$v', '$get_date')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function cr_suspenese($amount, $v) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `despense_account_history` (`id`, `description`, `cr`, `dr`, `balance`, `cr_date`) VALUES (NULL, 'Transferred from Suspense acc to cash account', '$amount', '0', '$v', current_timestamp());";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //bal account to bank to vault
    public function bank_statem($uid, $loan_id, $amount, $cus, $bank, $status, $nbal) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`,`balance`) VALUES (NULL, '$uid', '$status', '0', '$amount', '$get_date', '$bank','$cus','$nbal')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //bal account to bank to vault
    public function bank_refundsc($amount, $bank_bal, $banks_id, $bank_names, $de) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `bank_statement` (`id`, `cr`, `dr`, `date_cr`, `bank_id`,`balance`,`description`) VALUES (NULL, '0', '$amount', '$get_date', '$banks_id', '$bank_bal','$de / cash acc to $bank_names')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //bal account to bank to vault
    public function bank_refundscxx($amount, $bank_bal, $banks_id, $bank_names, $de, $tdates) {
        $get_date = $tdates;
        $query = "INSERT INTO `bank_statement` (`id`, `cr`, `dr`, `date_cr`, `bank_id`,`balance`,`description`) VALUES (NULL, '0', '$amount', '$get_date', '$banks_id', '$bank_bal','$de / suspense acc to $bank_names')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //bal account to bank to vault
    public function bank_refunds($amount, $bank_bal, $banks_id, $bank_names, $de, $date_cr) {
        $get_date = $date_cr;
        $query = "INSERT INTO `bank_statement` (`id`, `cr`, `dr`, `date_cr`, `bank_id`,`balance`,`description`) VALUES (NULL, '0', '$amount', '$get_date', '$banks_id', '$bank_bal','$de /from Vault to $bank_names')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    public function bank_new_loan($amount, $client, $bankid, $status, $nbal) {
        $get_date = date('Y-m-d H:i:s');
        $query = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`, `balance`, `description`) VALUES (NULL, '0', '$status', '$amount', '0', '$get_date', '$bankid','$client','$nbal','New Loan')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }


    public function bank_new_loans($amount, $client, $bankid, $status, $nbal, $cname, $rand, $posted_date, $loan_date) {

        $query = "INSERT INTO `bank_statement` (`id`, `loan_id`, `repay_id`, `cr`, `dr`, `date_cr`, `bank_id`, `cus_id`, `balance`, `description`, `dcode`,`posted_dated`) VALUES (NULL, '0', '$status', '$amount', '0', '$loan_date', '$bankid','$client','$nbal','$cname / New Loan','$rand', '$posted_date')";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }



    public function staffs_account($hos_key) {
        $query = "SELECT * FROM staffs where host_key='$hos_key'";
        $q = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($q)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->fn = $row['fn'];
            $obj->ln = $row['ln'];
            $obj->email = $row['email'];
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function count_staff_per_dpt($class_id) {
        $query = "select * from staffs where dpt_id='$class_id'";
        $run_query = $this->run_query($query);
        return $this->get_number_of_row($run_query);
    }

    public function db_banks($bankid, $nbal) {
        $query = "update banks set bal='$nbal' where id='$bankid'";
        return $this->runner($query);
    }

    public function cash_cr($s, $e) {
        $query = "SELECT SUM(cr) AS cash_c FROM cash_report where date_cr<'$s'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->cash_c = $row['cash_c'];
        $user_list[] = $obj;
        return $obj;

    }

    public function banks_balance($s, $e, $id) {
        $query = "SELECT SUM(cr) as cr, SUM(dr) as dr from bank_statement WHERE date_cr >= '$s' and date_cr <= '$e' and bank_id='$id' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->cr = $row['cr'];
        $obj->dr = $row['dr'];
        $user_list[] = $obj;
        return $obj;
    }


    public function cash_s_balance($s, $e) {
        $query = "SELECT SUM(cr) as cr, SUM(dr) as dr from cash_report WHERE date_cr>='$s' and date_cr<='$e' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->cr = $row['cr'];
        $obj->dr = $row['dr'];
        $user_list[] = $obj;
        return $obj;
    }

    public function vot_s_balance($s, $e) {
        $query = "SELECT SUM(cr) as cr, SUM(dr) as dr from vault_report WHERE date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->cr = $row['cr'];
        $obj->dr = $row['dr'];
        $user_list[] = $obj;
        return $obj;
    }

    public function sus_s_balance($s, $e) {
        $query = "SELECT SUM(cr) as cr, SUM(dr) as dr from despense_account_history WHERE cr_date >= '$s' and cr_date <= '$e' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->cr = $row['cr'];
        $obj->dr = $row['dr'];
        $user_list[] = $obj;
        return $obj;
    }


    public function banks_last_balance($s, $e, $id) {
        $query = "SELECT * FROM `bank_statement` WHERE date_cr >= '$s' and date_cr <= '$e' and bank_id='$id' and auto_transaction='1' ORDER by id desc limit 1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->balance = $row['balance'];
        $user_list[] = $obj;
        return $obj;
    }

    public function cash_last_balance($s, $e) {
        $query = "SELECT * FROM `cash_report` WHERE date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' ORDER by id desc limit 1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->balance = $row['balance'];
        $user_list[] = $obj;
        return $obj;
    }

    public function vot_last_balance($s, $e) {
        $query = "SELECT * FROM `vault_report` WHERE date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1' ORDER by id desc limit 1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->balance = $row['balance'];
        $user_list[] = $obj;
        return $obj;
    }

    public function sus_last_balance($s, $e) {
        $query = "SELECT * FROM `despense_account_history` WHERE cr_date >= '$s' and cr_date <= '$e' and auto_transaction='1' ORDER by id desc limit 1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->balance = $row['balance'];
        $user_list[] = $obj;
        return $obj;
    }

    //cash account
    public function cash_report_last_balance($s, $e, $id) {
        $query = "SELECT * FROM `cash_report` WHERE date_cr >= '$s' and date_cr <= '$e'  ORDER by id desc limit 1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->balance = $row['balance'];
        $user_list[] = $obj;
        return $obj;

    }

    public function cash_repot_balance($s, $e) {
        $query = "SELECT SUM(cr) as cr, SUM(dr) as dr from cash_report WHERE date_cr >= '$s' and date_cr <= '$e' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->cr = $row['cr'];
        $obj->dr = $row['dr'];
        $user_list[] = $obj;
        return $obj;

    }

    public function cummulative($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and principal_paid_date >= '$s' and principal_paid_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    public function cummulative_paid_ss($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and loan_types='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    public function cummulative_paid($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and principal_paid_date >'2022-12-31' and loan_types='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }


    public function cummulative_paid_months($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and principal_paid_date>='2023-01-01 00:00:00' and principal_paid_date <='$e' and loan_types='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    public function cummulative_paid_weeks($s, $e) {
        $get_date = date('Y/M/D');
         $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and auto_transaction='1' and principal_paid_date>='$s' and principal_paid_date <='$e' and loan_types=1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }


    public function cummulative_paid_month($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid'  and principal_paid_date >= '$s' and principal_paid_date <= '$e' and auto_transaction='1' and loan_types='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    // public function free_paidcummulative_paid($id)
    // {
    //     $get_date = date('Y/M/D');
    //     $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and loan_id='$id' and auto_transaction='1' and principal_paid_date>'2023-06-01'";

    //     $row = $this->get_result($this->run_query($query));
    //     $obj = new stdClass();
    //     $obj->amountsxxx = $row['principal_paid'];
    //     $user_list[] = $obj;
    //     return $obj;
    // }


    public function free_paidcummulative_paid($id) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and customer_id='$id' and auto_transaction='1' and principal_paid_date>='2023-06-00' and rev_status!=1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amountsxxx = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    // public function loan_interest_free_paid()
    // {
    //     $query = "SELECT * FROM `loans` WHERE loan_type='Interest Free' ";
    //     $qx = $this->run_query($query);
    //     $user_list = array();
    //     while ($row = $this->get_result($qx)) {
    //         $obj = new stdClass();
    //         $obj->id = $row['id'];
    //         $obj->customer_id = $row['customer_id'];
    //         $obj->loan_date = $row['loan_date'];
    //         $obj->loan_amount = $row['loan_amount'];
    //         $get_work_cen = $this->free_paidcummulative_paid($row['id']);
    //         $obj->amountsxxx = $get_work_cen->amountsxxx;
    //         $user_list[] = $obj;
    //     }
    //     return $user_list;
    // }

    public function loan_interest_free_paid() {
        $query = "SELECT * FROM `loans` WHERE loan_type='Interest Free' group by customer_id";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $get_work_cen = $this->free_paidcummulative_paid($row['customer_id']);
            $obj->amountsxxx = $get_work_cen->amountsxxx;
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function loan_interest_bad_paid() {
        $query = "SELECT * FROM `loans` WHERE bad_debt='1'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_date = $row['loan_date'];
            $obj->loan_amount = $row['loan_amount'];
            $get_work_cen = $this->free_paidcummulative_paid($row['id']);
            $obj->amountsxxx = $get_work_cen->amountsxxx;
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function cummulative_dbt($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where  loan_date >= '$s' and loan_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }


    public function repayment_comfirm($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(cheque_amount) AS apid FROM repayment where  auto_transaction='1' and due_date >= '$s' and due_date <= '$e' and loan_types=1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['apid'];
        $user_list[] = $obj;
        return $obj;

    }
    public function repayment_comfirm_unpaid($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(cheque_amount) AS apid FROM repayment where  auto_transaction='0' and due_date >= '$s' and due_date <= '$e' and loan_types=1 and status=0";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['apid'];
        $user_list[] = $obj;
        return $obj;

    }

    //    public function cummulative_loans($s, $e)
//    {
//        $get_date = date('Y/M/D');
//        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' ";
//        $row = $this->get_result($this->run_query($query));
//        $obj = new stdClass();
//        $obj->loan_taken = $row['loan_taken'];
//        $user_list[] = $obj;
//        return $obj;
//
//    }

    public function cummulative_loans($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date >'2022-12-31'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }

    public function sum_cus_loans($e) {
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where customer_id='$e' ";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }
    public function sum_cus_rep($e) {
        $query = "SELECT SUM(cheque_amount) AS repayments FROM repayment where customer_id='$e' and principal_paid='paid' and rev_status!='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->repayments = $row['repayments'];
        $user_list[] = $obj;
        return $obj;

    }

    
    public function sum_cus_rev_balance($e) {
        $query = "SELECT SUM(cheque_amount) AS repayments_amount FROM repayment where customer_id='$e' and principal_paid='paid' and rev_status='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->repayments_amount = $row['repayments_amount'];
        $user_list[] = $obj;
        return $obj;

    }

     
    public function sum_cus_rev_principal($e) {
        $query = "SELECT SUM(principal) AS repayments_amount FROM repayment where customer_id='$e' and principal_paid='paid' and rev_status='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->repayments_amount = $row['repayments_amount'];
        $user_list[] = $obj;
        return $obj;

    }

    public function sum_cus_rev($e) {
        $query = "SELECT SUM(cheque_amount) AS repayments_rev FROM repayment where customer_id='$e' and rev_status='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->repayments_rev = $row['repayments_rev'];
        $user_list[] = $obj;
        return $obj;

    }

    public function cummulative_loans_m($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date >= '$s' and loan_date <= '$e' ";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;

    }


    // public function sum_free_lonas_test()
    // {
    //     $query = "SELECT SUM(loan_amount) AS xc FROM loans WHERE status='0' and loan_type='Interest Free' and loan_date>='2023-06-00' ";
    //     $row = $this->get_result($this->run_query($query));
    //     $obj = new stdClass();
    //     $obj->xc = $row['xc'];
    //     $user_list[] = $obj;
    //     return $obj;
    // }



    public function sum_free_lonas_test() {
        $query = "SELECT SUM(loan_amount) AS xc FROM loans WHERE  loan_type='Interest Free' and loan_date>='2023-06-00' ";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->xc = $row['xc'];
        $user_list[] = $obj;
        return $obj;
    }



    public function cummulative_loans_bad($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where bad_debt='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;
    }

    public function free_cummulative_loans($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type='Interest Free' and loan_date>='2023-06-00'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_taken = $row['loan_taken'];
        $user_list[] = $obj;
        return $obj;
    }


    public function inteest_dbt($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(interest) AS interest_paid FROM repayment where interest_paid='unpaid' and due_date >= '$s' and due_date <= '$e' and auto_transaction='0'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['interest_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    public function l_interest($s, $e) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(interest) AS interest_paid FROM repayment where interest_paid='paid' and interest_paid_date>= '$s' and interest_paid_date<='$e' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts_i = $row['interest_paid'];
        $user_list[] = $obj;
        return $obj;
    }


    public function loans_repayment_reportsxx() {
        $query = "SELECT customer_id FROM loans WHERE loans.loan_type='Interest Free'";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->customer_id = $row['customer_id'];

            $get_work_cen = $this->eew($row['customer_id']);
            $user_list[] = $obj;
        }
        return $user_list;
    }

    public function eew($ec) {
        $query = "update repayment set loan_types='0' where customer_id='$ec'";
        return $this->runner($query);
    }


    public function principal_report($s, $e) {
        $get_date = date('Y/M/D');
         $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and principal_paid_date >= '$s' and principal_paid_date <= '$e' and auto_transaction='1' and loan_types=1  and rev_status=0";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amountsed = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    public function interest_report($s, $e) {
        $query = "SELECT SUM(interest) AS principal_paid FROM repayment where interest_paid='paid' and interest_paid_date >= '$s' and interest_paid_date <= '$e' and auto_transaction='1'  and rev_status=0";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    //sum cr for vt
    public function cr_vts($s, $e) {
        $query = "SELECT SUM(cr) AS principal_paid FROM vault_report where date_cr >= '$s' and date_cr <= '$e' ";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;
    }

    //sum cr for cash
    public function cr_csah($s, $e) {
        $query = "SELECT SUM(cr) AS cash_report FROM cash_report where date_cr >= '$s' and date_cr <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['cash_report'];
        $user_list[] = $obj;
        return $obj;
    }

    //sum cr for cash
    public function cr_bank_acc($s, $e) {
        $query = "SELECT SUM(cr) AS bank_statement FROM bank_statement where date_cr >= '$s' and date_cr <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['bank_statement'];
        $user_list[] = $obj;
        return $obj;
    }

    //cash acc rp
    public function allendofdays($rtype) {
        $query = "select * from bank_statement where bank_id='$rtype' and  auto_transaction='1' and endofday='0' order by id asc";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->description = $row['description'];
            $obj->dr = $row['dr'];
            $obj->cr = $row['cr'];
            $obj->date_cr = $row['date_cr'];
            $obj->balance = $row['balance'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    //sum cr for cash
    public function cr_bank_acc_s($rtype, $s, $e) {
        $query = "SELECT SUM(cr) AS bank_statement FROM bank_statement where posted_dated >= '$s' and posted_dated <= '$e' and bank_id='$rtype' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['bank_statement'];
        $user_list[] = $obj;
        return $obj;
    }

    //sum cr for suspense
    public function cr_suspense($s, $e) {
        $query = "SELECT SUM(cr) AS despense_account_history FROM despense_account_history where cr_date >= '$s' and cr_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['despense_account_history'];
        $user_list[] = $obj;
        return $obj;
    }


    public function cr_suspense_cus($s, $e) {
        $query = "SELECT SUM(cr) AS amounts FROM customer_account where created_date >= '$s' and created_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['amounts'];
        $user_list[] = $obj;
        return $obj;
    }

    //sum dr for vt
    public function cr_vtsxx($s, $e) {
        $query = "SELECT SUM(dr) AS principal_x FROM vault_report where date_cr >= '$s' and date_cr <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amountsx = $row['principal_x'];
        $user_list[] = $obj;
        return $obj;
    }


    //sum dr for cash
    public function cr_vtsxxx($s, $e) {
        $query = "SELECT SUM(dr) AS principal_x FROM cash_report where date_cr >= '$s' and date_cr <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amountsx = $row['principal_x'];
        $user_list[] = $obj;
        return $obj;
    }


    //sum dr for cash
    public function dr_bank_acc($s, $e) {
        $query = "SELECT SUM(dr) AS bank_statement FROM bank_statement where date_cr >= '$s' and date_cr <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amountsx = $row['bank_statement'];
        $user_list[] = $obj;
        return $obj;

    }


    //sum dr for cash
    public function dr_bank_acc_s($rtype, $s, $e) {
        $query = "SELECT SUM(dr) AS bank_statement FROM bank_statement where posted_dated >= '$s' and posted_dated <= '$e' and bank_id='$rtype' and auto_transaction='1'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amountsx = $row['bank_statement'];
        $user_list[] = $obj;
        return $obj;

    }

    public function dr_suspense_cus($s, $e) {
        $query = "SELECT SUM(dr) AS amounts FROM customer_account where created_date >= '$s' and created_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['amounts'];
        $user_list[] = $obj;
        return $obj;
    }


    //sum dr for suspense
    public function suspense_dr($s, $e) {
        $query = "SELECT SUM(dr) AS despense_account_history FROM despense_account_history where cr_date >= '$s' and cr_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amountsx = $row['despense_account_history'];
        $user_list[] = $obj;
        return $obj;

    }

    public function seh_amount($rtype, $s, $e) {
        $query = "SELECT SUM(cheque_amount) AS cc FROM repayment where status='0' and bank_id='$rtype' and due_date >= '$s' and due_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->ccc = $row['cc'];
        $user_list[] = $obj;
        return $obj;
    }


    public function all_loans_acc($s, $e) {
        $query = "SELECT SUM(loan_amount) AS ccc FROM loans where status='0' and loan_date >= '$s' and loan_date <= '$e'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->ccc = $row['ccc'];
        $user_list[] = $obj;
        return $obj;

    }

    public function lc_total($s, $e) {
        $query = "SELECT SUM(loan_amount) AS ccc FROM loans where status='0' and loan_date >= '$s' and loan_date <= '$e' and loan_type!='Interest Free'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->ccc = $row['ccc'];
        $user_list[] = $obj;
        return $obj;

    }

    public function expen_rs($s, $e) {
        $query = "SELECT SUM(dr) AS total_ex FROM expenses_data where status='0' and date_added >= '$s' and date_added <= '$e' and auto_transaction='1' and type not in (101205,30062,30031,30032,30030,30072,30080,101208,50107,101189,101193,50109,50114,101187,50110,101216,101209,101220)";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->total_ex = $row['total_ex'];
        $user_list[] = $obj;
        return $obj;

    }

    public function principal_report_db($c, $lid) {
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and loan_id='$lid' and customer_id='$c'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->cbal = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;

    }

    public function loanpaid_cus($loan_id) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(principal) AS principal_paid FROM repayment where principal_paid='paid' and loan_id='$loan_id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['principal_paid'];
        $user_list[] = $obj;
        return $obj;

    }

    public function loanpaid_interest($loan_id) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(interest) AS interest_paid FROM repayment where interest_paid='paid' and loan_id='$loan_id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts_in = $row['interest_paid'];
        $user_list[] = $obj;
        return $obj;

    }
    public function loanpaid_interest123($loan_id) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(interest) AS interest_paid FROM repayment where interest_paid='paid' and customer_id='$loan_id'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts_in = $row['interest_paid'];
        $user_list[] = $obj;
        return $obj;

    }


    public function month_profit($hos_key, $check_month) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(amount) AS amounts FROM quee_user_test where host_key='$hos_key' and  month(date_added)='$check_month' and payment='paid'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->amounts = $row['amounts'];
        $user_list[] = $obj;
        return $obj;

    }


    public function yearly_profit($hos_key, $check_yearly) {
        $get_date = date('Y/M/D');
        $query = "SELECT SUM(amount) AS yearlys FROM quee_user_test where host_key='$hos_key' and  YEAR(date_added)='$check_yearly' and payment='paid'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->yearlys = $row['yearlys'];
        $user_list[] = $obj;
        return $obj;
    }

    public function getallDate($e) {
        $query = "SELECT MONTH('$e') as mdates";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->mdates = $row['mdates'];
        $user_list[] = $obj;
        return $obj;
    }

    public function getallDates() {
        $get_date = date('Y/m/d');
        $query = "SELECT MONTH('$get_date') as mdates";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->mdates = $row['mdates'];
        $user_list[] = $obj;
        return $obj;
    }

    public function getallDateyear() {
        $get_date = date('Y/m/d');
        $query = "SELECT YEAR('$get_date') as mdates_year";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->mdates_year = $row['mdates_year'];
        $user_list[] = $obj;
        return $obj;

    }

    public function getall_today() {
        $get_date = date('Y/m/d');
        $query = "SELECT DAY('$get_date') as todays";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->todays = $row['todays'];
        $user_list[] = $obj;
        return $obj;

    }

    //count number of staff in school
    public function count_staff() {
        $query = "select * from staffs";
        $run_query = $this->run_query($query);
        return $this->get_number_of_row($run_query);
    }


    // teacher list in school
    public function staffs_list() {
        $query = "SELECT * FROM staffs order by fullname asc";
        $q = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($q)) {
            $obj = new stdClass();
            $obj->id = $row['id'];
            $obj->fullname = $row['fullname'];
            $obj->nationality = $row['nationality'];
            $obj->state = $row['state'];
            $obj->city = $row['city'];
            $obj->qualification = $row['qualification'];
            $obj->gender = $row['gender'];
            $obj->marital = $row['marital'];
            $obj->address = $row['address'];
            $obj->phone = $row['phone'];
            $obj->email = $row['email'];
            $obj->photo_st = $row['photo_st'];
            $user_list[] = $obj;
        }
        return $user_list;
    }


    //update password staff end
    public function update_staff_password($get_user_id, $main_pass) {
        $query = "update staffs set password='$main_pass' where id='$get_user_id'";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //update password student end
    public function update_student_password($get_user_id, $main_pass) {
        $query = "update student set password='$main_pass' where id='$get_user_id'";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //update staff pic
    public function upload_staff_profile_pics($path, $get_user_id) {
        $query = "update staffs set photo_st='$path' where id='$get_user_id'";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }

    //update student pic
    public function upload_student_profile_pics($path, $get_user_id) {
        $query = "update student set photo='$path' where id='$get_user_id'";
        $run_qry = $this->run_query($query);
        if($run_qry == true) {
            return "success";
        } else {
            return "Invalid Command";
        }
    }



    public function cummulative_loans_by_backs($s, $e) {
        $get_date = date('Y/M/D');
        
        $query = "SELECT SUM(loan_amount) AS loan_bf FROM loans where loan_type!='Interest Free' and loan_date>'2023-05-31 00:00:00' AND loan_date<'$s'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_bf = $row['loan_bf'];
        $user_list[] = $obj;
        return $obj;

    }


    public function cummulative_paid_weeks_prev($s, $e) {
        $get_date = date('Y/M/D');
         $query = "SELECT SUM(principal) AS principal_paid_prev FROM repayment where principal_paid='paid' and auto_transaction='1' and principal_paid_date>'2023-06-01 00:00:00' and principal_paid_date <'$s' and loan_types=1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->principal_paid_prev = $row['principal_paid_prev'];
        $user_list[] = $obj;
        return $obj;
    }




}




//     public function cummulative_loans_montly($s, $e)
// {
//     $get_date = date('Y/M/D');
//     $query = "SELECT SUM(loan_amount) AS loan_taken FROM loans where loan_type!='Interest Free' and loan_date <'$s' and loan_date>'2023-05-30'";
//     $row = $this->get_result($this->run_query($query));
//     $obj = new stdClass();
//     $obj->loan_taken = $row['loan_taken'];
//     $user_list[] = $obj;
//     return $obj;

// }








class manage_loans extends controller {

    public function loans_datas() {
        //$query ="select * from loans where status='0' order by id desc";
        $query = "SELECT customer_id,loan_type,rate,status,cus_bankid,bank_id,customer_id, SUM(loan_amount) loan_amount from loans  GROUP by customer_id";
        $qx = $this->run_query($query);
        $user_list = array();
        while($row = $this->get_result($qx)) {
            $obj = new stdClass();
            // $obj->id = $row['customer_id'];
            $obj->customer_id = $row['customer_id'];
            $obj->loan_amount = $row['loan_amount'];
            //$obj->balance = $row['balance'];

            $obj->loan_type = $row['loan_type'];
            $obj->rate = $row['rate'];

            $obj->status = $row['status'];
            $obj->cus_bankid = $row['cus_bankid'];
            $obj->bank_id = $row['bank_id'];

            if($obj->customer_id == 0) {
                $obj->c_name = 'unset';
            } else {
                $get_work_cen = $this->edit_customer($row['customer_id']);
                $obj->c_name = $get_work_cen->c_name;
                $obj->revs = $get_work_cen->revs;
            }

            if($obj->cus_bankid == 0) {
                $obj->bank_name = 'unset';
            } else {
                $get_work_cen = $this->get_work_bank($row['cus_bankid']);
                $obj->bank_name = $get_work_cen->bank_name;
            }
            if($obj->bank_id == 0) {
                $obj->bank_names = 'unset';
            } else {
                $get_work_cent = $this->get_work_bank($row['bank_id']);
                $obj->bank_names = $get_work_cent->bank_name;
            }
            if($obj->customer_id == 0) {
                $obj->customer_id = 'unset';
            } else {
                $get_work_paid = $this->get_payment_hist($row['customer_id']);
                $obj->paid_principal = $get_work_paid->paid_principal;

            }
            //get the rev values
            if($obj->customer_id == 0) {
                $obj->customer_id = 'unset';
            } else {
                $get_work_paid = $this->get_payment_hist_rev($row['customer_id']);
                $obj->paid_principal_rev = $get_work_paid->paid_principal_rev;

            }

            if($obj->customer_id == 0) {
                $obj->customer_id = 'unset';
            } else {
                $get_work_paid = $this->get_payment_hist_interst($row['customer_id']);
                $obj->interrest_paid = $get_work_paid->interrest_paid;
            }

            $user_list[] = $obj;
        }
        return $user_list;
    }

    //merge the interest
    public function get_payment_hist($id) {
        //$query = "select * from banks where id='$id'";
        $query = "SELECT customer_id, SUM(principal) paid_principal from repayment where customer_id='$id' and principal_paid='paid' and auto_transaction='1' and rev_status!=1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->paid_principal = $row['paid_principal'];

        return $obj;
    }

    public function get_payment_hist_rev($id) {
        //$query = "select * from banks where id='$id'";
        $query = "SELECT customer_id, SUM(cheque_amount)  paid_principal_rev from repayment where customer_id='$id' and principal_paid='paid' and auto_transaction='1' and rev_status=1";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->paid_principal_rev = $row['paid_principal_rev'];

        return $obj;
    }

    //merge the interest
    public function get_payment_hist_interst($id) {
        //$query = "select * from banks where id='$id'";
        $query = "SELECT customer_id, SUM(interest) as interrest_paid from repayment where customer_id='$id' and interest_paid='paid'";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->interrest_paid = $row['interrest_paid'];

        return $obj;
    }



    public function totalgiven_loans_loans() {
        $query = "SELECT SUM(loan_amount) AS lon FROM loans";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->lon = $row['lon'];
        $user_list[] = $obj;
        return $obj;

    }

    public function totalgiven_loans() {
        $query = "SELECT SUM(total_loan) AS total_loansx FROM customer ";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->total_loansx = $row['total_loansx'];
        $user_list[] = $obj;
        return $obj;

    }



    public function totalpaids_loans() {
        $query = "SELECT SUM(loan_paid) AS loan_paid_loansx FROM customer";
        $row = $this->get_result($this->run_query($query));
        $obj = new stdClass();
        $obj->loan_paid_loansx = $row['loan_paid_loansx'];
        $user_list[] = $obj;
        return $obj;

    }


}
