    <?php
    include_once "inc/user_data.php";
    $app = new controller;
    $bank_names = ($app->get_request('bank_names'));
    $bal = base64_decode($app->get_request('bal'));
    $sid = base64_decode($app->get_request('sid'));
    $get_valuts = $app->get_cahs_acc();
    $expenses = $app->banks();
    ?>
    <!doctype html>
    <html lang="en">
    <head>
        <title>Inter-Account Transfer</title>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

        <link rel="icon" href="favicon.ico" type="image/x-icon">
        <!-- VENDOR CSS -->
        <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
        <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
        <link rel="stylesheet" href="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css">
        <link rel="stylesheet" href="assets/vendor/parsleyjs/css/parsley.css">
        <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
        <!-- MAIN CSS -->
        <link rel="stylesheet" href="assets/css/main.css">
        <link rel="stylesheet" href="assets/css/color_skins.css">
    </head>
    <body class="theme-cyan">
    <!-- Page Loader -->

    <!-- Overlay For Sidebars -->
    <div id="wrapper">
        <?php
        include_once "inc/header.php"
        ?>
        <?php
        include_once "inc/sidebar.php"
        ?>
        <div id="main-content">
            <div class="container-fluid">
                <div class="block-header">
                    <div class="row">
                        <div class="col-lg-5 col-md-8 col-sm-12">
                            <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                            class="fa fa-arrow-left"></i></a>Inter-Account Transfer</h2>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="index.html"><i class="icon-home"></i></a></li>
                                <li class="breadcrumb-item">Manage Account Transfer</li>
                                <li class="breadcrumb-item active">Inter-Account Transfer</li>
                            </ul>
                        </div>
                        <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                            <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                            </div>
                            <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                            </div>
                        </div>
                    </div>
                </div>

                <div class="row clearfix">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="body">
                                <form id="submitForm" method="post">
                                    <div class="form-group">
                                        <label>Send To</label>
                                        <select name="cat" class="form-control" required>
                                            <option value="">Choose Account</option>
                                            <?php
                                            foreach ($expenses as $vals) {
                                                ?>
                                                <option value="<?= $vals->id; ?>"><?= $vals->bank_name; ?></option>
                                                <?php
                                            }
                                            ?></select>
                                    </div>
                                    <div class="form-group">
                                        <label>Description</label>
                                        <input type="text" class="form-control" name="dc" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Amount</label>
                                        <input type="number" class="form-control" name="amount" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Created Date</label>
                                        <input type="datetime-local" class="form-control" name="cdate" required>
                                    </div>

                                    <div class="form-group">
                                        <label>Posted Date</label>
                                        <input type="datetime-local" class="form-control" name="posted" required>
                                    </div>



                                    <input type="hidden" name="bal" value="<?=  $bal = base64_decode($app->get_request('bal')); ?>">
                                    <input type="hidden" name="bank_id" value="<?= $sid = base64_decode($app->get_request('sid')); ?>">
                                    <input type="hidden" name="bank_name" value="<?= $bank_names = ($app->get_request('bank_names')); ?>">

                                    <br>
                                    <input type="submit" class="btn btn-primary" id="add_vot" value="Transfer Funds">
                             <br>
                             <br>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>

    </div>

    <!-- Javascript -->
    <script src="assets/bundles/libscripts.bundle.js"></script>
    <script src="assets/bundles/vendorscripts.bundle.js"></script>

    <script src="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js"></script>
    <script src="assets/vendor/parsleyjs/js/parsley.min.js"></script>

    <script src="assets/bundles/mainscripts.bundle.js"></script>
    <script src="assets/vendor/toastr/toastr.js"></script>
    <script>

        $(document).ready(function () {
          
            /* function to login user */
            $("#submitForm").on('submit',(function(e) {
                e.preventDefault();
                var btn = $("#add_vot");
                btn.attr('disabled', true).html("<i class='fa fa-spin fa-spinner'></i> processing");
                var datas = new FormData(this);
                $.ajax({
                    url: "ajax/inter_transfer",
                    type: "POST",
                    data: datas,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: (data)=> {

                        if(data.trim() == "done"){
                            toastr.success('Completed.', 'Success');
                            setTimeout(
                                function () {
                                    window.location.href='bank_mgt.php';
                                }, 3000);
                        }else{
                            toastr.error('Date Out of Post range.', 'Success');
                        }
                    },

                });
            }));




        });
    </script>
    </body>
    </html>