<?php
include_once "inc/user_data.php";
$app = new controller;
$rtype = $app->get_request('rtype');

$sdate = $app->get_request('sdate');

$edate = $app->get_request('edate');

$s = date("Y-m-d H:i:s", strtotime($sdate));
$e = date("Y-m-d H:i:s", strtotime($edate));

$principal_report = $app->interest_report($s,$e);
$exp = $app->expen_rs($s,$e);


?>
<!doctype html>
<html lang="en">
<head>
    <title>Loan Management</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">

    <link rel="stylesheet" href="assets/vendor/jquery-datatable/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedcolumns.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedheader.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/sweetalert/sweetalert.css"/>
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
    <style>
        td.details-control {
            background: url('assets/images/details_open.png') no-repeat center center;
            cursor: pointer;
        }

        tr.shown td.details-control {
            background: url('assets/images/details_close.png') no-repeat center center;
        }
    </style>
    <style type="text/css" media="print">

        div#DivIdToPrint {
            display: inline ;
        }

    </style>
</head>

<body class="theme-blue">

<!-- Page Loader -->
<div class="page-loader-wrapper">
    <div class="loader">
        <div class="m-t-30"><img src="logo.png" width="48" height="48" alt="Daros"></div>
        <p>Please wait...</p>
    </div>
</div>
<!-- Overlay For Sidebars -->

<div id="wrapper">

    <?php
    include_once "inc/header.php";
    ?>

    <?php
    include_once "inc/sidebar.php";
    ?>

    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a>Profit & Loss Reports</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard"><i class="fa fa-home fa-lg"></i></a></li>
                            <li class="breadcrumb-item active">Manage Loan</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card" id="DivIdToPrint">
                        <div class="header">
                            <button class="fa-pull-right btn btn-primary m-l-30 font-weight-bold" id="ccv"
                                    onclick='printContent("DivIdToPrint");'>Print Report
                            </button>
                            <br>
                        </div>


                        <div class="card">
                            <div class="body w_user" style="font-weight: bold;color: black;font-size: 15px">
                                <img class="" src="logo.png"
                                     alt="">
                                <div class="wid-u-info">
                                    <h5 style="font-weight: bold;color: black;font-size: 20px">Periodic Profit & Loss Reports </h5>
                                    <p class="text-muted m-b-0">P&L Reports
                                        <br>From <?php echo $newDate = date("d-m-Y:h:i:s", strtotime($s)); ?> <span class="text-danger">To</span><?php echo $newDate = date("d-m-Y:h:i:s", strtotime($e)); ?> </p>
                                </div>
                                <hr>
                                <div class="row">

                                </div>
                            </div>
                        </div>

                        <div class="body">

                            <div class="table-responsive">
                                <table class="table table-striped table-hover js-basic-example dataTable table-custom ">
                                    <thead>
                                    <tr style="font-weight: bold;color: black">
                                        <th>SN</th>
                                        <th>Account Name</th>
                                        <th>Debit</th>
                                        <th>Credit</th>
                                        <!--<th>Balance</th>-->
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr style="font-weight: bold;color: black;font-size: 19px">
                                        <td>1</td>

                                        <td>Interest Loan Acc</td>
                                        <td>₦0</td>
                                        <td>₦<?= number_format($principal_report->amounts); ?></td>
                                        <!--<td>₦0</td>-->
                                    </tr>
                                    <?php
                                    $get_total_info = $app->expenses_data_pl($s,$e);
                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        $sn++;
                                        ?>
                                        <tr class="dn_<?= $values->id; ?>" style="font-weight: bold;color: black;font-size: 19px">
                                            <td><?= $sn+1; ?></td>
                                            <td><?= $values->expenese_name; ?></td>

                                            <td>₦<?= number_format($values->tal,2); ?></td>
                                            <td>₦0.00</td>
                                            <!--<td>₦0</td>-->
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                    <tr style="font-weight: bold;color: black;font-size: 20px">
                                        <td></td>
                                        <td style="font-weight: bold;color: black;font-size: 20px">Total Transaction</td>
                                        <td style="font-weight: bold;color: black;font-size: 20px">Dr ₦<?= number_format($exp->total_ex,2); ?></td>
                                        <td style="font-weight: bold;color: black;font-size: 20px">Cr ₦<?= number_format($principal_report->amounts,2); ?></td>
                                        <td></td>
                                    </tr>
                                    <tr style="font-weight: bold;color: black;font-size: 17px">
                                        <td></td>
                                        <td></td>
                                        <td style="font-weight: bold;color: black;font-size: 20px">Net Profit ₦<?php $drs = $exp->total_ex; $crs=$principal_report->amounts; echo number_format($crs-$drs,2); ?></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/bundles/datatablescripts.bundle.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.print.min.js"></script>

<script src="assets/vendor/sweetalert/sweetalert.min.js"></script> <!-- SweetAlert Plugin Js -->
<script src="assets/vendor/toastr/toastr.js"></script>
<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/js/pages/tables/jquery-datatable.js"></script>

<script>

    function printContent(el) {
        $("#ccv").hide();
        var restorepage = $('body').html();
        var printcontent = $('#' + el).clone();
        $('body').empty().html(printcontent);
        window.print();
        $('body').html(restorepage);
    }
</script>
</body>
</html>
