<?php
include_once "inc/user_data.php";
$app = new controller;
$cus_id = base64_decode($app->get_request('sid'));
 $cus_bank = $app->get_request('bank_names');
//fet
$cinfo = $app->get_work_bank($cus_id);
?>
<!doctype html>
<html lang="en">
<head>
    <title>Funds Transfer</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css">
    <link rel="stylesheet" href="assets/vendor/parsleyjs/css/parsley.css">
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
</head>
<body class="theme-cyan">
<!-- Page Loader -->

<!-- Overlay For Sidebars -->
<div id="wrapper">
    <?php
    include_once "inc/header.php"
    ?>
    <?php
    include_once "inc/sidebar.php"
    ?>
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> Transfer Funds To Vault</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href=""><i class="icon-home"></i></a></li>
                            <li class="breadcrumb-item">Manage Banks</li>
                            <li class="breadcrumb-item active">Funds Transfer</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-md-4">
                    <div class="card">
                        <div class="body">
                            <form id="submitForm" method="post">
                                <div class="form-group">
                                    <label>Current Balance</label>
                                    <input type="text" class="form-control" name="bank_bals"
                                           value="<?= ($cinfo->balance); ?>" readonly required>
                                </div>

                                <div class="form-group">
                                    <label>Amount</label>
                                    <input type="number" class="form-control" name="amount"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label>Description</label>
                                    <input type="text" class="form-control" name="description"
                                           required>
                                </div>
                                <div class="form-group">
                                    <label>Creation Date</label>
                                    <input type="datetime-local" class="form-control" name="date_cr"
                                           required>
                                </div>


                                <input type="hidden" value="<?= $cus_id;  ?>" name="banks_id">
                                <input type="hidden" value="<?= $cus_bank;  ?>" name="banks_name">

                                <br>
                                <input type="submit" class="btn btn-primary" id="add_vot" value="Transfer Funds">
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js"></script>
<script src="assets/vendor/parsleyjs/js/parsley.min.js"></script>

<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/vendor/toastr/toastr.js"></script>
<script>

    $(document).ready(function () {


        /* function to login user */
        $("#submitForm").on('submit',(function(e) {
            e.preventDefault();
            var btn = $("#add_vot");
            btn.attr('disabled', true).html("<i class='fa fa-spin fa-spinner'></i> processing");
            var datas = new FormData(this);
            $.ajax({
                url: "ajax/transfer_to_main",
                type: "POST",
                data: datas,
                contentType: false,
                cache: false,
                processData:false,
                success: (data)=> {
                    if(data.trim() == "done"){
                        toastr.success('Completed.', 'Success');
                        setTimeout(
                            function () {
                                window.location.href='bank_mgt.php';
                            }, 3000);
                    }else{

                    }
                },

            });
        }));




    });
</script>
</body>
</html>