<?php
include_once "inc/user_data.php";
$app = new controller;
 $cus_id= base64_decode($app->get_request('sid'));
//fet
$cinfo = $app->edit_customer($cus_id);
?>
<!doctype html>
<html lang="en">
<head>
    <title>Edit Customer</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css">
    <link rel="stylesheet" href="assets/vendor/parsleyjs/css/parsley.css">
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
</head>
<body class="theme-cyan">
<!-- Page Loader -->
<div class="page-loader-wrapper">
        <div class="loader">
            <div class="m-t-30"><img src="assets/images/logo-icon.svg" width="48" height="48" alt="Lucid"></div>
            <p>Please wait...</p>
        </div>
</div>
<!-- Overlay For Sidebars -->
<div id="wrapper">
    <?php
    include_once "inc/header.php"
    ?>
    <?php
    include_once "inc/sidebar.php"
    ?>
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> Edit Customer</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html"><i class="icon-home"></i></a></li>
                            <li class="breadcrumb-item">Manage Customer</li>
                            <li class="breadcrumb-item active">Edit Customer Info</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-md-12">
                    <div class="card">
                        <div class="body">
                            <form id="basic-form" method="post" novalidate>
                                <div class="form-group">
                                    <label>Title </label>
                                    <input type="text" class="form-control" id="tittle" value="<?= $cinfo->tittle;  ?>" readonly>
                                </div>
                                <div class="form-group">
                                    <label>Full Name </label>
                                    <input type="text" class="form-control" id="c_name" value="<?= $cinfo->c_name;  ?>" required>
                                </div>
                                <div class="form-group">
                                    <label>Gender </label>
                                    <select id="sex" class="form-control">
                                        <option><?= $cinfo->sex;  ?></option>
                                        <option>Male</option>
                                        <option>Female</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>work center </label>
                                    <select id="work_center" class="form-control">
                                        <option value="<?= $cinfo->work_center;  ?>"><?= $cinfo->center_name;  ?> Active</option>
                                        <?php
                                        $work_center = $app->work_center();
                                        foreach ($work_center as $vals){
                                        ?>
                                        <option value="<?= $vals->id;  ?>"><?= $vals->center_name;  ?></option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>Department</label>
                                    <input type="text" class="form-control" id="dpt" value="<?= $cinfo->dpt;  ?>" required>
                                </div>
                                <div class="form-group">
                                    <label>work address</label>
                                    <input type="email" class="form-control" value="<?= $cinfo->work_address;  ?>" id="work_address" required>
                                </div>
                                <div class="form-group">
                                    <label>home address</label>
                                    <input type="text" class="form-control" value="<?= $cinfo->home_address;  ?>" id="home_address" required>
                                </div>
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" class="form-control" value="<?= $cinfo->cphone;  ?>" id="cphone" required>
                                </div>
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="text" class="form-control" value="<?= $cinfo->cemail;  ?>" id="cemail" required>
                                </div>
                                <input type="hidden" id="cus_id" value="<?= $cus_id;  ?>">

                                <br>
                                <button type="button" class="btn btn-primary" id="add_customer">Edit Customer</button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js"></script>
<script src="assets/vendor/parsleyjs/js/parsley.min.js"></script>

<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/vendor/toastr/toastr.js"></script>
<script>

    $(document).ready(function () {
        // show when page load
        // toastr.info('Page Loaded!');
        $("#add_customer").click(function () {
            //form paras
            let tittle = $("#tittle").val();
            let c_name = $("#c_name").val();
            let sex = $("#sex").val();
            let work_center = $("#work_center").val();
            let dpt = $("#dpt").val();
            let work_address = $("#work_address").val();
            let home_address = $("#home_address").val();
            let cphone = $("#cphone").val();
            let cemail = $("#cemail").val();
            let cus_id = $("#cus_id").val();

            //disable btn
            const btn = $("#add_customer");
            btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Adding Customer...');
            //call Ajax
            if (c_name === '' || cus_id ===0) {
                toastr.warning('Please Add input.', 'warning');
                const btn = $("#add_customer");
                btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
            } else {
                $.ajax({
                    url: "ajax/edit_customer.php",
                    method: "GET",
                    data: {
                        tittle: tittle,
                        c_name: c_name,
                        sex: sex,
                        work_center: work_center,
                        dpt: dpt,
                        work_address: work_address,
                        home_address: home_address,
                        cphone: cphone,
                        cemail: cemail,
                        cus_id:cus_id
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('The Account has been Updated.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }

                    }
                });

            }
        });


    });
</script>
</body>
</html>