<?php
include_once "inc/user_data.php";
$app = new controller;
?>
<!doctype html>
<html lang="en">
<head>
    <title>Expenses Management</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedcolumns.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedheader.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/sweetalert/sweetalert.css"/>
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
    <style>
        td.details-control {
            background: url('assets/images/details_open.png') no-repeat center center;
            cursor: pointer;
        }

        tr.shown td.details-control {
            background: url('assets/images/details_close.png') no-repeat center center;
        }
    </style>
</head>

<body class="theme-blue">

<!-- Page Loader -->
<div class="page-loader-wrapper">
    <div class="loader">
        <div class="m-t-30"><img src="assets/images/logo-icon.svg" width="48" height="48" alt="Lucid"></div>
        <p>Please wait...</p>
    </div>
</div>
<!-- Overlay For Sidebars -->

<div id="wrapper">

    <?php
    include_once "inc/header.php";
    ?>

    <?php
    include_once "inc/sidebar.php";
    ?>

    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> Expenses Management</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard"><i class="fa fa-home fa-lg"></i></a></li>
                            <li class="breadcrumb-item active">Expenses Controls</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="header">
                            <a href="cash_account.php">
                                <button class="fa-pull-left btn btn-primary m-l-30">New Expense </button>
                            </a>
                            <br>
                        </div>

                        <div class="body">

                            <div class="table-responsive">
                                <table class="table table-striped table-hover js-basic-example dataTable table-custom">
                                    <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Trans Date</th>
<!--                                        <th>Account Name</th>-->
                                        <th>Expenses Category</th>
                                        <th>Descriptions</th>
                                        <th>Debit</th>
                                        <th>Credit</th>
                                        <th>Balance</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody class="dexpenses">
                                    <?php
                                    $get_total_info = $app->expenses_data_s();
                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        $sn++;
                                        ?>
                                        <tr class="dn_<?= $values->id; ?>" >
                                            <td><?= $sn; ?></td>
                                            <td><?= $values->date_added; ?></td>
<!--                                            <td>Bank / Cash Acc</td>-->
                                            <td style="text-transform: capitalize"><?= $values->expenese_name; ?></td>
                                            <td><?= $values->description; ?></td>
                                            <td>₦<?= number_format($values->dr,2); ?></td>
                                            <td>₦<?= number_format($values->cr,2); ?></td>
                                            <td>₦<?= number_format($values->balance,2); ?></td>
                                            <td>Approved</td>
                                            <td>
                                                <?php
                                                if($values->rev==1){

                                                }else{
                                                   include "revsersal_btn.php";
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>

                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/bundles/datatablescripts.bundle.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.print.min.js"></script>

<script src="assets/vendor/sweetalert/sweetalert.min.js"></script> <!-- SweetAlert Plugin Js -->
<script src="assets/vendor/toastr/toastr.js"></script>
<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/js/pages/tables/jquery-datatable.js"></script>
<script>
    $(document).ready(function () {

        $(".dexpenses").on("click", "tr button.del_staff_remove", function(e){
            const uid = $(this).attr("data-id");
            const wc = $(this).attr("data-fullname");
            const sb = $(this).attr("data-nb");
            const cr = $(this).attr("data-cr");
            const bal = $(this).attr("data-bal");
            const acc = $(this).attr("data-acc");
            const dcode = $(this).attr("data-dcode");
            const types = $(this).attr("data-types");
            const bankid = $(this).attr("data-bankid");
            const ty = $(this).attr("data-ty");

            // show in text field
            $("#ty").val(ty);
            $("#uid").val(uid);
            $("#fullname").val(wc);
            $("#sb").val(sb);
            $("#cr").val(cr);
            $("#bal").val(bal);
            $("#acc").val(acc);
            $("#dcode").val(dcode);
            $("#types").val(types);
            $("#bankid").val(bankid);
            //display modal
            $('#del_staff').modal('show');

            $("#del_stf").click(function () {
                const uid = $("#uid").val();
                const sb = $("#sb").val();
                const cr = $("#cr").val();
                const bal = $("#bal").val();
                const acc = $("#acc").val();
                const ty = $("#ty").val();
                const dcode = $("#dcode").val();
                const types = $("#types").val();
                const description = $("#description").val();
                const bankid = $("#bankid").val();
                const btn = $("#del_stf");
                btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Deleting...');
                //validate
                //call Ajax
                if (uid === '' || description === '') {
                    toastr.warning('Please check selection.', 'warning');

                    const btn = $("#del_stf");
                    btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
                    setTimeout(
                        function () {
                            window.location.href='expense_data.php';
                        }, 1000);
                } else {
                    $.ajax({
                        url: "ajax/del_expenses_datas.php",
                        method: "GET",
                        data: {
                            uid: uid,cr:cr,bal:bal,acc:acc,dcode:dcode,types:types,description:description,bankid:bankid,ty:ty
                        },
                        success: function (data) {
                            console.log(data)
                            if (data.trim() == 'done') {
                                toastr.success('The expenses has been removed.', 'Success');
                                let cc = '.'+sb;
                                $(cc).hide();
                                window.location.href='expense_data.php';

                            }
                        }
                    });

                }

            });
        });

        // $(".del_staff_remove").click(function () {
        //
        //
        // });

    })
</script>
</body>
</html>

<!--delete staff-->
<div class="modal fade" id="del_staff" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="title font-weight-bold" id="defaultModalLabel">Delete expenses</h6>
            </div>
            <span class="m-l-10 text-danger">Please note this action is permanent</span>
            <div class="modal-body">
                <div class="row clearfix">
                    <div class="col-8">
                        <div class="form-group">
                            <input type="text" class="form-control font-weight-bold" id="fullname"
                                   placeholder="" readonly>
                        </div>

                        <div class="form-group">
                            <input type="text" class="form-control font-weight-bold" id="description"
                                   placeholder="Description">
                        </div>
                    </div>
                    <div class="col-12">
                        <input type="hidden" id="uid">
                        <input type="hidden" id="sb">
                        <input type="hidden" id="cr">
                        <input type="hidden" id="bal">
                        <input type="hidden" id="acc">
                        <input type="hidden" id="dcode">
                        <input type="hidden" id="types">
                        <input type="hidden" id="bankid">
                        <input type="hidden" id="ty">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="del_stf" class="btn btn-primary font-weight-bold">Cancel expenses</button>
                <button type="button" class="btn btn-danger font-weight-bold" data-dismiss="modal">X</button>
            </div>
        </div>
    </div>
</div>